/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.settings.builtin;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.settings.data.LoadContext;
import io.github.lightman314.lightmanscurrency.api.settings.data.SavedSettingData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.settings.EasyTraderSettingsNode;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class TaxSettings
extends EasyTraderSettingsNode<TraderData> {
    public TaxSettings(TraderData trader) {
        super("taxes", trader);
    }

    @Override
    protected String getRequiredPermission() {
        return "editSettings";
    }

    @Override
    public MutableComponent getName() {
        return LCText.DATA_CATEGORY_TRADER_TAXES.get(new Object[0]);
    }

    @Override
    public void saveSettings(SavedSettingData.MutableNodeAccess data) {
        data.setIntValue("acceptable_rate", this.trader.getAcceptableTaxRate());
    }

    @Override
    public void loadSettings(SavedSettingData.NodeAccess data, LoadContext context) {
        this.trader.setAcceptableTaxRate(data.getIntValue("acceptable_rate"));
    }

    @Override
    protected void writeLines(SavedSettingData.NodeAccess data, Consumer<Component> lineWriter) {
        lineWriter.accept((Component)TaxSettings.formatEntry((Component)LCText.DATA_ENTRY_TRADER_TAXES_RATE.get(new Object[0]), data.getIntValue("acceptable_rate")));
    }
}

