/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.settings.builtin.trades;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.settings.SettingsNode;
import io.github.lightman314.lightmanscurrency.api.settings.SettingsSubNode;
import io.github.lightman314.lightmanscurrency.api.settings.data.LoadContext;
import io.github.lightman314.lightmanscurrency.api.settings.data.SavedSettingData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.common.util.LookupHelper;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.MutableComponent;

public abstract class TradeSubNode<T extends TradeData, N extends SettingsNode>
extends SettingsSubNode<N> {
    protected final int index;

    public TradeSubNode(N parent, int index) {
        super(parent);
        this.index = index;
    }

    public final HolderLookup.Provider registryAccess() {
        return LookupHelper.getRegistryAccess();
    }

    @Nullable
    protected abstract T getTrade();

    @Override
    public String getSubKey() {
        return "trade_" + this.index;
    }

    @Override
    public MutableComponent getName() {
        return LCText.DATA_ENTRY_TRADER_TRADES.get(this.index + 1);
    }

    @Override
    public boolean allowLoading(LoadContext context) {
        return context.hasPermission("editTrades");
    }

    @Override
    public final void saveSettings(SavedSettingData.MutableNodeAccess data) {
        T trade = this.getTrade();
        if (trade != null) {
            this.saveTrade(data, trade);
        }
    }

    protected abstract void saveTrade(SavedSettingData.MutableNodeAccess var1, T var2);

    @Override
    public final void loadSettings(SavedSettingData.NodeAccess data, LoadContext context) {
        T trade = this.getTrade();
        if (trade != null) {
            this.loadTrade(data, trade, context);
        }
    }

    protected abstract void loadTrade(SavedSettingData.NodeAccess var1, T var2, LoadContext var3);
}

