/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.upgrades;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public final class UpgradeData {
    public static final Codec<UpgradeData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.BOOL).fieldOf("booleans").forGetter(data -> data.boolData), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.LONG).fieldOf("integers").forGetter(data -> data.intData), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.DOUBLE).fieldOf("floats").forGetter(data -> data.floatData), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("strings").forGetter(data -> data.stringData), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)CompoundTag.CODEC).fieldOf("compounds").forGetter(data -> data.tagData)).apply((Applicative)builder, UpgradeData::new));
    public static final StreamCodec<FriendlyByteBuf, UpgradeData> STREAM_CODEC = StreamCodec.of((b, d) -> {
        UpgradeData.encodeMap(b, d.boolData, FriendlyByteBuf::writeBoolean);
        UpgradeData.encodeMap(b, d.intData, FriendlyByteBuf::writeLong);
        UpgradeData.encodeMap(b, d.floatData, FriendlyByteBuf::writeDouble);
        UpgradeData.encodeMap(b, d.stringData, FriendlyByteBuf::writeUtf);
        UpgradeData.encodeMap(b, d.tagData, (a, t) -> a.writeNbt((Tag)t));
    }, b -> {
        Map<String, Boolean> boolData = UpgradeData.decodeMap(b, FriendlyByteBuf::readBoolean);
        Map<String, Long> intData = UpgradeData.decodeMap(b, FriendlyByteBuf::readLong);
        Map<String, Double> floatData = UpgradeData.decodeMap(b, FriendlyByteBuf::readDouble);
        Map<String, String> stringData = UpgradeData.decodeMap(b, FriendlyByteBuf::readUtf);
        Map<String, CompoundTag> tagData = UpgradeData.decodeMap(b, a -> a.readNbt());
        return new UpgradeData(boolData, intData, floatData, stringData, tagData);
    });
    public static final UpgradeData EMPTY = new UpgradeData();
    private final Map<String, Boolean> boolData;
    private final Map<String, Long> intData;
    private final Map<String, Double> floatData;
    private final Map<String, String> stringData;
    private final Map<String, CompoundTag> tagData;

    private static <T> void encodeMap(@Nonnull FriendlyByteBuf buffer, @Nonnull Map<String, T> map, @Nonnull BiConsumer<FriendlyByteBuf, T> encoder) {
        buffer.writeInt(map.size());
        map.forEach((key, val) -> {
            buffer.writeUtf(key);
            encoder.accept(buffer, val);
        });
    }

    private static <T> Map<String, T> decodeMap(@Nonnull FriendlyByteBuf buffer, @Nonnull Function<FriendlyByteBuf, T> decoder) {
        HashMap<String, T> map = new HashMap<String, T>();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            String key = buffer.readUtf();
            T val = decoder.apply(buffer);
            map.put(key, val);
        }
        return map;
    }

    private UpgradeData() {
        this.boolData = ImmutableMap.of();
        this.intData = ImmutableMap.of();
        this.floatData = ImmutableMap.of();
        this.stringData = ImmutableMap.of();
        this.tagData = ImmutableMap.of();
    }

    private UpgradeData(@Nonnull Map<String, Boolean> boolData, @Nonnull Map<String, Long> intData, @Nonnull Map<String, Double> floatData, @Nonnull Map<String, String> stringData, @Nonnull Map<String, CompoundTag> tagData) {
        this.boolData = ImmutableMap.copyOf(boolData);
        this.intData = ImmutableMap.copyOf(intData);
        this.floatData = ImmutableMap.copyOf(floatData);
        this.stringData = ImmutableMap.copyOf(stringData);
        this.tagData = ImmutableMap.copyOf(tagData);
    }

    public boolean isEmpty() {
        return this.boolData.isEmpty() && this.intData.isEmpty() && this.floatData.isEmpty() && this.stringData.isEmpty() && this.tagData.isEmpty();
    }

    public boolean hasBoolValue(@Nonnull String tag) {
        return this.boolData.containsKey(tag);
    }

    public boolean hasIntValue(@Nonnull String tag) {
        return this.intData.containsKey(tag);
    }

    public boolean hasLongValue(@Nonnull String tag) {
        return this.intData.containsKey(tag);
    }

    public boolean hasFloatValue(@Nonnull String tag) {
        return this.floatData.containsKey(tag);
    }

    public boolean hasDoubleValue(@Nonnull String tag) {
        return this.floatData.containsKey(tag);
    }

    public boolean hasStringValue(@Nonnull String tag) {
        return this.stringData.containsKey(tag);
    }

    public boolean hasCompoundValue(@Nonnull String tag) {
        return this.tagData.containsKey(tag);
    }

    public boolean getBooleanValue(@Nonnull String tag) {
        return this.boolData.getOrDefault(tag, false);
    }

    public int getIntValue(@Nonnull String tag) {
        return this.intData.getOrDefault(tag, 0L).intValue();
    }

    public long getLongValue(@Nonnull String tag) {
        return this.intData.getOrDefault(tag, 0L);
    }

    public float getFloatValue(@Nonnull String tag) {
        return this.floatData.getOrDefault(tag, 0.0).floatValue();
    }

    public double getDoubleValue(@Nonnull String tag) {
        return this.floatData.getOrDefault(tag, 0.0);
    }

    @Nonnull
    public String getStringValue(@Nonnull String tag) {
        return this.stringData.getOrDefault(tag, "");
    }

    @Nonnull
    public CompoundTag getCompoundValue(@Nonnull String tag) {
        return this.tagData.getOrDefault(tag, new CompoundTag());
    }

    @Nonnull
    public Mutable makeMutable() {
        return new Mutable(this.boolData, this.intData, this.floatData, this.stringData, UpgradeData.copyTags(this.tagData));
    }

    public boolean equals(Object obj) {
        if (obj instanceof UpgradeData) {
            UpgradeData other = (UpgradeData)obj;
            return this.boolData.equals(other.boolData) && this.intData.equals(other.intData) && this.floatData.equals(other.floatData) && this.stringData.equals(other.stringData) && this.tagData.equals(other.tagData);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.boolData, this.intData, this.floatData, this.stringData, this.tagData);
    }

    private static Map<String, CompoundTag> copyTags(Map<String, CompoundTag> original) {
        HashMap<String, CompoundTag> copy = new HashMap<String, CompoundTag>();
        original.forEach((key, tag) -> copy.put((String)key, tag.copy()));
        return copy;
    }

    public static final class Mutable {
        private final Map<String, Boolean> boolData;
        private final Map<String, Long> intData;
        private final Map<String, Double> floatData;
        private final Map<String, String> stringData;
        private final Map<String, CompoundTag> tagData;

        private Mutable(@Nonnull Map<String, Boolean> boolData, @Nonnull Map<String, Long> intData, @Nonnull Map<String, Double> floatData, @Nonnull Map<String, String> stringData, @Nonnull Map<String, CompoundTag> tagData) {
            this.boolData = new HashMap<String, Boolean>(boolData);
            this.intData = new HashMap<String, Long>(intData);
            this.floatData = new HashMap<String, Double>(floatData);
            this.stringData = new HashMap<String, String>(stringData);
            this.tagData = new HashMap<String, CompoundTag>(tagData);
        }

        public boolean hasBoolValue(@Nonnull String tag) {
            return this.boolData.containsKey(tag);
        }

        public boolean hasIntValue(@Nonnull String tag) {
            return this.intData.containsKey(tag);
        }

        public boolean hasLongValue(@Nonnull String tag) {
            return this.intData.containsKey(tag);
        }

        public boolean hasFloatValue(@Nonnull String tag) {
            return this.floatData.containsKey(tag);
        }

        public boolean hasDoubleValue(@Nonnull String tag) {
            return this.floatData.containsKey(tag);
        }

        public boolean hasStringValue(@Nonnull String tag) {
            return this.stringData.containsKey(tag);
        }

        public boolean hasCompoundValue(@Nonnull String tag) {
            return this.tagData.containsKey(tag);
        }

        public boolean getBooleanValue(@Nonnull String tag) {
            return this.boolData.getOrDefault(tag, false);
        }

        public int getIntValue(@Nonnull String tag) {
            return this.intData.getOrDefault(tag, 0L).intValue();
        }

        public long getLongValue(@Nonnull String tag) {
            return this.intData.getOrDefault(tag, 0L);
        }

        public float getFloatValue(@Nonnull String tag) {
            return this.floatData.getOrDefault(tag, 0.0).floatValue();
        }

        public double getDoubleValue(@Nonnull String tag) {
            return this.floatData.getOrDefault(tag, 0.0);
        }

        @Nonnull
        public String getStringValue(@Nonnull String tag) {
            return this.stringData.getOrDefault(tag, "");
        }

        @Nonnull
        public CompoundTag getCompoundValue(@Nonnull String tag) {
            return this.tagData.getOrDefault(tag, new CompoundTag());
        }

        public void setBooleanValue(@Nonnull String tag, boolean value) {
            this.boolData.put(tag, value);
        }

        public void setIntValue(@Nonnull String tag, int value) {
            this.intData.put(tag, Long.valueOf(value));
        }

        public void setLongValue(@Nonnull String tag, long value) {
            this.intData.put(tag, value);
        }

        public void setFloatValue(@Nonnull String tag, float value) {
            this.floatData.put(tag, Double.valueOf(value));
        }

        public void setDoubleValue(@Nonnull String tag, double value) {
            this.floatData.put(tag, value);
        }

        public void setStringValue(@Nonnull String tag, @Nonnull String value) {
            this.stringData.put(tag, value);
        }

        public void setCompoundValue(@Nonnull String tag, @Nonnull CompoundTag value) {
            this.tagData.put(tag, value.copy());
        }

        public void merge(@Nonnull UpgradeData data) {
            data.boolData.forEach(this::setBooleanValue);
            data.intData.forEach(this::setLongValue);
            data.floatData.forEach(this::setDoubleValue);
            data.stringData.forEach(this::setStringValue);
            data.tagData.forEach(this::setCompoundValue);
        }

        @Nonnull
        public UpgradeData makeImmutable() {
            return new UpgradeData(this.boolData, this.intData, this.floatData, this.stringData, UpgradeData.copyTags(this.tagData));
        }
    }
}

