/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.variants.item;

import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
public interface IVariantItem {
    default public ResourceLocation getItemID() {
        IVariantItem iVariantItem = this;
        if (iVariantItem instanceof ItemLike) {
            ItemLike item = (ItemLike)iVariantItem;
            return BuiltInRegistries.ITEM.getKey((Object)item.asItem());
        }
        throw new IllegalStateException("IVariantItem must be applied to an Item class!");
    }

    default public List<ResourceLocation> getValidVariants() {
        return ModelVariantDataManager.getPotentialVariants(this.getItemID());
    }

    default public int requiredModels() {
        return 0;
    }

    @Nullable
    default public ResourceLocation getDefaultModel(int index) {
        if (this.requiredModels() > 0) {
            throw new IllegalStateException("Variant Item requires custom model, but does not provide the default for that model!");
        }
        return null;
    }
}

