/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyViewer;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ATMTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.bank.BankInteractionWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.bank.IBankInteractionHandler;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.menus.ATMMenu;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class InteractionTab
extends ATMTab
implements IBankInteractionHandler {
    BankInteractionWidget accountWidget;

    public InteractionTab(ATMScreen screen) {
        super(screen);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return ItemIcon.ofItem(ModBlocks.COINPILE_GOLD);
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_ATM_INTERACT.get(new Object[0]);
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.accountWidget = this.addChild(((BankInteractionWidget.Builder)BankInteractionWidget.builder().position(screenArea.pos)).handler(this).spacing(19).build());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        MutableComponent accountName = EasyText.literal("ERROR FINDING ACCOUNT");
        IBankAccount account = this.getBankAccount();
        if (account != null) {
            accountName = account.getName();
        }
        TextRenderUtil.drawCenteredText(gui, TextRenderUtil.fitString((Component)accountName, this.screen.getXSize() - 12), this.screen.getXSize() / 2, 75, 0x404040);
    }

    @Override
    public IBankAccount getBankAccount() {
        return ((ATMMenu)this.screen.getMenu()).getBankAccount();
    }

    @Override
    public IMoneyViewer getCoinAccess() {
        return ((ATMMenu)this.screen.getMenu()).getMoneyHandler();
    }
}

