/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.salary;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.money.bank.salary.SalaryData;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.salary.SalarySubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.salary.SalaryTab;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SalaryInfoTab
extends SalarySubTab.EditTab {
    public SalaryInfoTab(SalaryTab tab, ATMScreen screen) {
        super(tab, screen);
    }

    @Override
    public IconData getIcon() {
        return IconUtil.ICON_TRADER_ALT;
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return LCText.TOOLTIP_BANK_SALARY_INFO.get(new Object[0]);
    }

    @Override
    public int getRequiredPermissions(Player player, SalaryData selectedSalary) {
        if (selectedSalary.isTarget(player)) {
            return 1;
        }
        return 2;
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
    }

    @Override
    public void renderBG(EasyGuiGraphics gui) {
        int accessLevel;
        SalaryData salary = this.parent.getSelectedSalary();
        if (salary == null) {
            return;
        }
        int leftEdge = 6;
        int width = this.screen.getXSize() - 12;
        int center = this.screen.getXSize() / 2;
        int yPos = 16;
        if (!salary.isAutoSalaryEnabled()) {
            TextRenderUtil.drawCenteredMultilineText(gui, (Component)LCText.GUI_BANK_SALARY_INFO_DISABLED.get(new Object[0]), 6, width, 6, (int)ChatFormatting.YELLOW.getColor(), true);
        }
        if (salary.getSalaryDelay() > 0L) {
            TextRenderUtil.drawCenteredText(gui, (Component)LCText.GUI_BANK_SALARY_INFO_DELAY.get(new TimeUtil.TimeData(salary.getSalaryDelay()).getShortString()), center, 30, 0x404040);
            if (salary.isAutoSalaryEnabled()) {
                long nextTrigger = salary.getLastSalaryTime() + salary.getSalaryDelay();
                long timeUntilNextTrigger = Math.max(0L, nextTrigger - TimeUtil.getCurrentTime());
                TextRenderUtil.drawCenteredText(gui, (Component)LCText.GUI_BANK_SALARY_INFO_NEXT_TRIGGER.get(new TimeUtil.TimeData(timeUntilNextTrigger).getShortString(2)), center, 42, 0x404040);
            }
        }
        if (!salary.getSalary().isEmpty()) {
            TextRenderUtil.drawCenteredText(gui, (Component)LCText.GUI_BANK_SALARY_INFO_SALARY.get(salary.getSalary().getText()), center, 54, 0x404040);
        }
        if ((accessLevel = this.parent.getSalaryAccess()) >= 2) {
            MoneyValue totalCost = salary.getTotalSalaryCost(false);
            if (!totalCost.isEmpty()) {
                TextRenderUtil.drawCenteredMultilineText(gui, (Component)LCText.GUI_BANK_SALARY_INFO_REQUIRED_FUNDS.get(totalCost.getText()), leftEdge, width, 66, 0x404040);
            }
            if (salary.getLoginRequiredForSalary() && !(totalCost = salary.getTotalSalaryCost(true)).isEmpty()) {
                TextRenderUtil.drawCenteredMultilineText(gui, (Component)LCText.GUI_BANK_SALARY_INFO_CURRENT_REQUIRED_FUNDS.get(totalCost.getText()), leftEdge, width, 86, 0x404040);
            }
            MutableComponent fundsWarning = null;
            if (!salary.canAffordNextSalary(true)) {
                fundsWarning = LCText.GUI_BANK_SALARY_INFO_INSUFFICIENT_FUNDS.get(new Object[0]);
            } else if (!salary.canAffordNextSalary(false)) {
                fundsWarning = LCText.GUI_BANK_SALARY_INFO_POSSIBLE_INSUFFICIENT_FUNDS.get(new Object[0]);
            }
            if (fundsWarning != null) {
                TextRenderUtil.drawCenteredMultilineText(gui, (Component)fundsWarning, leftEdge, width, 106, (int)ChatFormatting.YELLOW.getColor(), true);
            }
            if (salary.failedLastSalaryAttempt()) {
                TextRenderUtil.drawCenteredMultilineText(gui, (Component)LCText.GUI_BANK_SALARY_INFO_LAST_ATTEMPT_FAILED.get(new Object[0]), leftEdge, width, 136, (int)ChatFormatting.YELLOW.getColor(), true);
            }
        }
    }

    @Override
    public boolean renderInventoryLabel() {
        SalaryData salary = this.parent.getSelectedSalary();
        if (salary == null) {
            return super.renderInventoryLabel();
        }
        return !salary.failedLastSalaryAttempt();
    }
}

