/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade;

import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertType;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AlertData {
    private final MutableComponent message;
    public final AlertType type;

    private AlertData(@Nonnull MutableComponent message, @Nonnull AlertType type) {
        this.message = message;
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setShaderColor(@Nonnull EasyGuiGraphics gui, float mult, boolean isHovered) {
        int color = isHovered ? this.type.hoverColor : this.type.color;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        gui.setColor(red * mult, green * mult, blue * mult, this.type.alpha);
    }

    public MutableComponent getFormattedMessage() {
        return this.message.withStyle(this.type.format);
    }

    public static int compare(AlertData a, AlertData b) {
        return Integer.compare(a.type.priority, b.type.priority) * -1;
    }

    public static AlertData helpful(@Nonnull MutableComponent message) {
        return AlertData.of(message, AlertType.HELPFUL);
    }

    public static AlertData helpful(@Nonnull TextEntry message) {
        return AlertData.of(message.get(new Object[0]), AlertType.HELPFUL);
    }

    public static AlertData neutral(@Nonnull MutableComponent message) {
        return AlertData.of(message, AlertType.NEUTRAL);
    }

    public static AlertData neutral(@Nonnull TextEntry message) {
        return AlertData.of(message.get(new Object[0]), AlertType.NEUTRAL);
    }

    public static AlertData warn(@Nonnull MutableComponent message) {
        return AlertData.of(message, AlertType.WARN);
    }

    public static AlertData warn(@Nonnull TextEntry message) {
        return AlertData.of(message.get(new Object[0]), AlertType.WARN);
    }

    public static AlertData error(@Nonnull MutableComponent message) {
        return AlertData.of(message, AlertType.ERROR);
    }

    public static AlertData error(@Nonnull TextEntry message) {
        return AlertData.of(message.get(new Object[0]), AlertType.ERROR);
    }

    public static AlertData of(@Nonnull MutableComponent message, @Nonnull AlertType type) {
        return new AlertData(message, type);
    }
}

