/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.api.variants.block.IVariantBlock;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.models.VariantModelHelper;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.models.VariantModelLocation;
import io.github.lightman314.lightmanscurrency.common.blockentity.variant.IVariantSupportingBlockEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.common.util.TriState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class VariantBlockModel
implements IDynamicBakedModel {
    public static final ModelProperty<ResourceLocation> VARIANT = new ModelProperty();
    public static final ModelProperty<BlockState> STATE = new ModelProperty();
    private final Map<QuadCacheKey, List<BakedQuad>> quadCache = new HashMap<QuadCacheKey, List<BakedQuad>>();
    private final Map<RenderCacheKey, BakedModel> blockModelCache = new HashMap<RenderCacheKey, BakedModel>();
    private final IVariantBlock block;
    private final BakedModel defaultModel;

    public VariantBlockModel(IVariantBlock block, BakedModel defaultModel) {
        this.block = block;
        this.defaultModel = defaultModel;
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
        ResourceLocation variantID = null;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IVariantSupportingBlockEntity) {
            IVariantSupportingBlockEntity be = (IVariantSupportingBlockEntity)blockEntity;
            variantID = be.getCurrentVariant();
        }
        return modelData.derive().with(VARIANT, variantID).with(STATE, (Object)state).build();
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        return this.getQuadData(extraData, state, side, renderType);
    }

    public boolean useAmbientOcclusion() {
        return this.defaultModel.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.defaultModel.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.defaultModel.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.defaultModel.isCustomRenderer();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.defaultModel.getParticleIcon();
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        return this.getModel(data).getParticleIcon(data);
    }

    public ItemOverrides getOverrides() {
        return this.defaultModel.getOverrides();
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return this.getModel(data).getRenderTypes(state, rand, data);
    }

    public TriState useAmbientOcclusion(BlockState state, ModelData data, RenderType renderType) {
        return this.getModel(data).useAmbientOcclusion(state, data, renderType);
    }

    public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        return this.defaultModel.applyTransform(transformType, poseStack, applyLeftHandTransform);
    }

    private List<BakedQuad> getQuadData(ModelData data, @Nullable BlockState state, @Nullable Direction side, @Nullable RenderType renderType) {
        List quads;
        QuadCacheKey key = new QuadCacheKey((ResourceLocation)data.get(VARIANT), state, side, renderType);
        if (this.quadCache.containsKey(key)) {
            return this.quadCache.get(key);
        }
        ResourceLocation variantID = key.variantID;
        RandomSource rand = RandomSource.create();
        if (variantID == null) {
            List quads2 = this.defaultModel.getQuads(state, side, rand, data, renderType);
            this.quadCache.put(key, quads2);
            return quads2;
        }
        ModelVariant variant = ModelVariantDataManager.getVariant(variantID);
        if (variant == null || !variant.getTargets().contains(this.block.getBlockID())) {
            List quads3 = this.defaultModel.getQuads(state, side, rand, data, renderType);
            this.quadCache.put(key, quads3);
            return quads3;
        }
        VariantModelLocation modelID = VariantModelHelper.getModelID(variant, variantID, this.block, state);
        if (modelID == null) {
            quads = this.defaultModel.getQuads(state, side, rand, data, renderType);
        } else {
            BakedModel model = ModelVariantDataManager.getModel(modelID);
            quads = model.getQuads(state, side, rand, data, renderType);
        }
        this.quadCache.put(key, quads);
        return quads;
    }

    private BakedModel getModel(ModelData data) {
        RenderCacheKey key = new RenderCacheKey((ResourceLocation)data.get(VARIANT), (BlockState)data.get(STATE));
        if (this.blockModelCache.containsKey(key)) {
            return this.blockModelCache.get(key);
        }
        ResourceLocation variantID = key.variantID;
        if (variantID == null) {
            this.blockModelCache.put(key, this.defaultModel);
            return this.defaultModel;
        }
        ModelVariant variant = ModelVariantDataManager.getVariant(variantID);
        if (variant == null || !variant.getTargets().contains(this.block.getBlockID())) {
            this.blockModelCache.put(key, this.defaultModel);
            return this.defaultModel;
        }
        VariantModelLocation modelID = VariantModelHelper.getModelID(variant, variantID, this.block, (BlockState)data.get(STATE));
        BakedModel model = modelID == null ? this.defaultModel : ModelVariantDataManager.getModel(modelID);
        this.blockModelCache.put(key, model);
        return model;
    }

    private record QuadCacheKey(@Nullable ResourceLocation variantID, @Nullable BlockState state, @Nullable Direction side, @Nullable RenderType renderType) {
        @Override
        public int hashCode() {
            int stateHash = 0;
            if (this.state != null) {
                stateHash = BlockModelShaper.stateToModelLocation((BlockState)this.state).hashCode();
            }
            return Objects.hash(this.variantID, stateHash, this.side, this.renderType == null ? 0 : this.renderType.name.hashCode());
        }

        @Override
        public String toString() {
            return "QuadCacheKey[" + String.valueOf(this.variantID == null ? "null" : this.variantID) + "," + String.valueOf(this.state == null ? "null" : BlockModelShaper.stateToModelLocation((BlockState)this.state)) + "," + String.valueOf(this.side == null ? "null" : this.side) + "," + (this.renderType == null ? "null" : this.renderType.name) + "]";
        }
    }

    private record RenderCacheKey(@Nullable ResourceLocation variantID, @Nullable BlockState state) {
    }
}

