/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.api.variants.VariantProvider;
import io.github.lightman314.lightmanscurrency.api.variants.item.IVariantItem;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.models.VariantModelLocation;
import io.github.lightman314.lightmanscurrency.common.attachments.WalletHandler;
import io.github.lightman314.lightmanscurrency.common.core.ModAttachmentTypes;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class WalletLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public static final ResourceLocation NULL_MODEL = VersionUtil.lcResource("item/wallet_hip/wallet_base");

    public WalletLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(@Nonnull PoseStack pose, @Nonnull MultiBufferSource bufferSource, int light, @Nonnull T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        WalletHandler handler = (WalletHandler)entity.getData(ModAttachmentTypes.WALLET_HANDLER);
        if (handler == null || !handler.visible()) {
            return;
        }
        ItemStack wallet = handler.getVisibleWallet();
        if (WalletItem.isWallet(wallet)) {
            pose.pushPose();
            pose.mulPose(MathUtil.fromAxisAngleDegree(MathUtil.getZP(), 180.0f));
            pose.translate(0.125f, -0.46875f, 0.375f);
            Minecraft mc = Minecraft.getInstance();
            BakedModel model = WalletLayer.getWalletModel(wallet, mc);
            mc.getItemRenderer().render(wallet, ItemDisplayContext.FIXED, false, pose, bufferSource, light, OverlayTexture.NO_OVERLAY, model);
            pose.popPose();
        }
    }

    private static BakedModel getWalletModel(ItemStack wallet, Minecraft mc) {
        VariantModelLocation modelID;
        ModelVariant variant;
        ResourceLocation variantID;
        IVariantItem variantItem = VariantProvider.getVariantItem(wallet);
        if (variantItem != null && (variantID = (ResourceLocation)wallet.getOrDefault(ModDataComponents.MODEL_VARIANT, null)) != null && (variant = ModelVariantDataManager.getVariant(variantID)) != null && variant.isValidTarget(wallet) && (modelID = VariantModelLocation.basic(variantID, variantItem.getItemID(), 0)) != null) {
            return ModelVariantDataManager.getModel(modelID);
        }
        ResourceLocation modelID2 = (ResourceLocation)wallet.getOrDefault(ModDataComponents.WALLET_MODEL, (Object)NULL_MODEL);
        return mc.getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)modelID2));
    }
}

