/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.client.config.CustomItemScaleData;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.ItemTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.items.data.ItemStackData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class GachaBallRenderer {
    public static final ModelResourceLocation MODEL = ModelResourceLocation.standalone((ResourceLocation)VersionUtil.lcResource("item/gacha_ball_model"));

    public static void renderGachaBall(ItemStack ball, PoseStack pose, MultiBufferSource buffer, int lightLevel, int id) {
        pose.pushPose();
        pose.translate(0.5, 0.5, 0.5);
        Minecraft mc = Minecraft.getInstance();
        BakedModel model = mc.getModelManager().getModel(MODEL);
        ItemRenderer itemRenderer = mc.getItemRenderer();
        itemRenderer.render(ball, ItemDisplayContext.FIXED, false, pose, buffer, lightLevel, OverlayTexture.NO_OVERLAY, model);
        pose.popPose();
        if (!((Boolean)LCConfig.CLIENT.drawGachaBallItem.get()).booleanValue()) {
            return;
        }
        ItemStack contents = ((ItemStackData)ball.getOrDefault(ModDataComponents.GACHA_ITEM, (Object)ItemStackData.EMPTY)).stack();
        if (contents.isEmpty()) {
            return;
        }
        pose.pushPose();
        pose.translate(0.5, 0.4375, 0.5);
        pose.scale(0.6f, 0.6f, 0.6f);
        pose.mulPose(ItemTraderBlockEntityRenderer.getRotation(0.0f));
        float scale = ((CustomItemScaleData)LCConfig.CLIENT.itemScaleOverrides.get()).getCustomScale(contents);
        pose.scale(scale, scale, scale);
        itemRenderer.renderStatic(contents, ItemDisplayContext.FIXED, lightLevel, OverlayTexture.NO_OVERLAY, pose, buffer, null, id);
        pose.popPose();
    }
}

