/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.custom_models;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class CustomModelTest {
    private static final Map<ResourceLocation, Function<JsonObject, CustomModelTest>> TYPES = new HashMap<ResourceLocation, Function<JsonObject, CustomModelTest>>();
    private final ResourceLocation type;

    public static void register(ResourceLocation type, Function<JsonObject, CustomModelTest> parser) {
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, parser);
        }
    }

    public CustomModelTest(ResourceLocation type) {
        this.type = type;
    }

    public abstract boolean test(@Nullable BlockEntity var1, ItemStack var2);

    public final JsonObject write() {
        JsonObject json = new JsonObject();
        this.writeAdditional(json);
        json.addProperty("type", this.type.toString());
        return json;
    }

    protected abstract void writeAdditional(JsonObject var1);

    public static CustomModelTest parse(JsonObject json) throws JsonSyntaxException, ResourceLocationException {
        String typeString = GsonHelper.getAsString((JsonObject)json, (String)"type");
        ResourceLocation type = VersionUtil.parseResource(typeString);
        if (TYPES.containsKey(type)) {
            return TYPES.get(type).apply(json);
        }
        throw new JsonSyntaxException(typeString + " is not a valid Custom Model Test Type!");
    }
}

