/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks.traderblocks;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.traders.blocks.TraderBlockRotatable;
import io.github.lightman314.lightmanscurrency.api.variants.block.IVariantBlock;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.interfaces.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class CardDisplayBlock
extends TraderBlockRotatable
implements IItemTraderBlock,
IVariantBlock {
    public static final int TRADECOUNT = 4;
    private final String name;
    private final Color color;

    public CardDisplayBlock(@Nonnull BlockBehaviour.Properties properties, @Nonnull String name, @Nonnull Color color) {
        super(properties);
        this.name = name;
        this.color = color;
    }

    @Override
    protected boolean isBlockOpaque() {
        return false;
    }

    @Override
    protected BlockEntity makeTrader(BlockPos pos, BlockState state) {
        return new ItemTraderBlockEntity(pos, state, 4);
    }

    @Override
    public BlockEntityType<?> traderType() {
        return ModBlockEntities.ITEM_TRADER.get();
    }

    @Override
    public List<BlockEntityType<?>> validTraderTypes() {
        return ImmutableList.of(ModBlockEntities.ITEM_TRADER.get());
    }

    @Override
    protected Supplier<List<Component>> getItemTooltips() {
        return LCText.TOOLTIP_ITEM_TRADER.asTooltip(4);
    }

    @Nonnull
    public String getDescriptionId() {
        return this.name;
    }

    @Override
    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        tooltip.add((Component)LCText.TOOLTIP_COLORED_ITEM.get(this.color.getComponent()));
        super.appendHoverText(stack, context, tooltip, flagIn);
    }
}

