/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.data.types.TraderDataCache;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;

public class TraderArgument
implements ArgumentType<TraderData> {
    public static final SimpleCommandExceptionType ERROR_NOT_FOUND = new SimpleCommandExceptionType((Message)LCText.ARGUMENT_TRADER_NOT_FOUND.get(new Object[0]));
    public static final SimpleCommandExceptionType ERROR_NOT_RECOVERABLE = new SimpleCommandExceptionType((Message)LCText.ARGUMENT_TRADER_NOT_RECOVERABLE.get(new Object[0]));
    private final boolean acceptPersistentIDs;
    private final boolean onlyRecoverableTraders;

    private TraderArgument(boolean acceptPersistentIDs, boolean onlyRecoverableTraders) {
        this.acceptPersistentIDs = acceptPersistentIDs;
        this.onlyRecoverableTraders = onlyRecoverableTraders;
    }

    public static TraderArgument trader() {
        return new TraderArgument(false, false);
    }

    public static TraderArgument recoverableTrader() {
        return new TraderArgument(false, true);
    }

    public static TraderArgument traderWithPersistent() {
        return new TraderArgument(true, false);
    }

    public static TraderData getTrader(CommandContext<CommandSourceStack> commandContext, String name) throws CommandSyntaxException {
        return (TraderData)commandContext.getArgument(name, TraderData.class);
    }

    public TraderData parse(StringReader reader) throws CommandSyntaxException {
        TraderData t;
        TraderDataCache data;
        String traderID;
        block6: {
            traderID = reader.readUnquotedString();
            data = TraderDataCache.TYPE.get(false);
            if (TraderArgument.isNumerical(traderID)) {
                try {
                    TraderData t2;
                    long id = Long.parseLong(traderID);
                    if (id >= 0L && (t2 = data.getTrader(id)) != null) {
                        if (this.onlyRecoverableTraders && !t2.isRecoverable()) {
                            throw ERROR_NOT_RECOVERABLE.createWithContext((ImmutableStringReader)reader);
                        }
                        return t2;
                    }
                }
                catch (Throwable error) {
                    if (!(error instanceof CommandSyntaxException)) break block6;
                    CommandSyntaxException e = (CommandSyntaxException)error;
                    throw e;
                }
            }
        }
        if (this.acceptPersistentIDs && (t = data.getTrader(traderID)) != null) {
            return t;
        }
        throw ERROR_NOT_FOUND.createWithContext((ImmutableStringReader)reader);
    }

    private static boolean isNumerical(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        List<TraderData> allTraders = TraderAPI.getApi().GetAllTraders(false);
        for (TraderData t : allTraders) {
            if (this.onlyRecoverableTraders && !t.isRecoverable()) continue;
            suggestionsBuilder.suggest(String.valueOf(t.getID()));
            if (!this.acceptPersistentIDs || !t.isPersistent()) continue;
            suggestionsBuilder.suggest(t.getPersistentID());
        }
        return suggestionsBuilder.buildFuture();
    }

    public static class Info
    implements ArgumentTypeInfo<TraderArgument, Template> {
        public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
            buffer.writeBoolean(template.acceptPersistentIDs);
            buffer.writeBoolean(template.onlyRecoverableTraders);
        }

        @Nonnull
        public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
            return new Template(buffer.readBoolean(), buffer.readBoolean());
        }

        public void serializeToJson(Template template, JsonObject json) {
            json.addProperty("acceptPersistentIDs", Boolean.valueOf(template.acceptPersistentIDs));
            json.addProperty("onlyRecoverableTraders", Boolean.valueOf(template.onlyRecoverableTraders));
        }

        @Nonnull
        public Template unpack(TraderArgument argument) {
            return new Template(argument.acceptPersistentIDs, argument.onlyRecoverableTraders);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<TraderArgument> {
            final boolean acceptPersistentIDs;
            final boolean onlyRecoverableTraders;

            Template(boolean checkPersistentIDs, boolean onlyRecoverableTraders) {
                this.acceptPersistentIDs = checkPersistentIDs;
                this.onlyRecoverableTraders = onlyRecoverableTraders;
            }

            @Nonnull
            public TraderArgument instantiate(@Nonnull CommandBuildContext context) {
                return new TraderArgument(this.acceptPersistentIDs, this.onlyRecoverableTraders);
            }

            @Nonnull
            public ArgumentTypeInfo<TraderArgument, ?> type() {
                return Info.this;
            }
        }
    }
}

