/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.enchantments;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.common.core.ModEnchantments;
import io.github.lightman314.lightmanscurrency.common.enchantments.CoinMagnetEnchantment;
import io.github.lightman314.lightmanscurrency.common.util.LookupHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public abstract class WalletEnchantment {
    private static final List<Pair<ResourceKey<Enchantment>, IWalletTooltipProvider>> TOOLTIP_PROVIDERS = new ArrayList<Pair<ResourceKey<Enchantment>, IWalletTooltipProvider>>();

    public static void registerWalletTooltipProvider(@Nonnull ResourceKey<Enchantment> enchantment, @Nonnull IWalletTooltipProvider provider) {
        TOOLTIP_PROVIDERS.add((Pair<ResourceKey<Enchantment>, IWalletTooltipProvider>)Pair.of(enchantment, (Object)provider));
    }

    public static void addWalletEnchantmentTooltips(@Nonnull List<Component> tooltip, @Nonnull ItemStack item, @Nonnull Item.TooltipContext context) {
        if (context.registries() == null) {
            return;
        }
        context.registries().lookup(Registries.ENCHANTMENT).ifPresent(enchantmentRegistry -> {
            ItemEnchantments enchantments = item.getAllEnchantments(enchantmentRegistry);
            for (Pair<ResourceKey<Enchantment>, IWalletTooltipProvider> pair : TOOLTIP_PROVIDERS) {
                int level;
                Holder<Enchantment> holder = LookupHelper.lookupEnchantment(context.registries(), (ResourceKey<Enchantment>)((ResourceKey)pair.getFirst()));
                if (holder == null || (level = enchantments.getLevel(holder)) <= 0) continue;
                ((IWalletTooltipProvider)pair.getSecond()).addWalletTooltips(tooltip, level, item);
            }
        });
    }

    static {
        WalletEnchantment.registerWalletTooltipProvider(ModEnchantments.COIN_MAGNET, CoinMagnetEnchantment::addWalletTooltips);
    }

    public static interface IWalletTooltipProvider {
        public void addWalletTooltips(List<Component> var1, int var2, ItemStack var3);
    }
}

