/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.filter.IItemTradeFilter;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.items.data.FilterData;
import io.github.lightman314.lightmanscurrency.common.menus.ItemFilterMenu;
import io.github.lightman314.lightmanscurrency.common.util.TooltipHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FilterItem
extends Item
implements IItemTradeFilter {
    public FilterItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        List<Component> extraTooltips = this.getCustomTooltip(stack);
        if (extraTooltips != null) {
            tooltip.addAll(extraTooltips);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (!level.isClientSide) {
            int indexOfItem = -1;
            Inventory inv = player.getInventory();
            for (int i = 0; i < inv.getContainerSize() && indexOfItem < 0; ++i) {
                if (inv.getItem(i) != heldItem) continue;
                indexOfItem = i;
            }
            if (indexOfItem >= 0) {
                ItemFilterMenu.OpenMenu(player, indexOfItem);
            }
        }
        return InteractionResultHolder.success((Object)heldItem);
    }

    @Override
    @Nullable
    public Predicate<ItemStack> getFilter(ItemStack stack) {
        FilterData filter = (FilterData)stack.getOrDefault(ModDataComponents.FILTER_DATA, (Object)FilterData.EMPTY);
        if (filter.isEmpty()) {
            return null;
        }
        return filter.asItemPredicate();
    }

    @Override
    @Nullable
    public List<Component> getCustomTooltip(ItemStack stack) {
        boolean notFirst;
        FilterData filter = (FilterData)stack.getOrDefault(ModDataComponents.FILTER_DATA, (Object)FilterData.EMPTY);
        if (filter.isEmpty()) {
            return null;
        }
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (!filter.entries().isEmpty()) {
            tooltip.add((Component)LCText.TOOLTIP_ITEM_TRADE_FILTER_ITEM_LABEL.getWithStyle(ChatFormatting.GOLD));
            MutableComponent itemLine = EasyText.empty();
            notFirst = false;
            for (ResourceLocation entry : filter.entries()) {
                Item item;
                if (notFirst) {
                    itemLine.append((Component)LCText.GUI_SEPERATOR.get(new Object[0]));
                }
                if ((item = (Item)BuiltInRegistries.ITEM.get(entry)) == Items.AIR) continue;
                itemLine.append(new ItemStack((ItemLike)item).getHoverName());
                notFirst = true;
            }
            tooltip.addAll(TooltipHelper.splitTooltips((Component)itemLine, new ChatFormatting[0]));
        }
        if (!filter.tags().isEmpty()) {
            tooltip.add((Component)LCText.TOOLTIP_ITEM_TRADE_FILTER_TAG_LABEL.getWithStyle(ChatFormatting.GOLD));
            MutableComponent tagLine = EasyText.empty();
            notFirst = false;
            for (ResourceLocation entry : filter.tags()) {
                if (notFirst) {
                    tagLine.append((Component)LCText.GUI_SEPERATOR.get(new Object[0]));
                }
                tagLine.append("#" + entry.toString());
                notFirst = true;
            }
            tooltip.addAll(TooltipHelper.splitTooltips((Component)tagLine, new ChatFormatting[0]));
        }
        return tooltip;
    }

    private static boolean shouldDisplayItem(Item item, @Nullable IItemHandler availableItems) {
        if (availableItems == null) {
            return true;
        }
        for (int i = 0; i < availableItems.getSlots(); ++i) {
            if (availableItems.getStackInSlot(i).getItem() != item) continue;
            return true;
        }
        return false;
    }
}

