/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeItem;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeable;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeableBlock;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeData;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class UpgradeItem
extends Item
implements IUpgradeItem {
    protected final UpgradeType upgradeType;
    private boolean addTooltips = true;
    Function<UpgradeData, List<Component>> customTooltips = null;

    public UpgradeItem(UpgradeType upgradeType, Item.Properties properties) {
        super(properties);
        this.upgradeType = upgradeType;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isCrouching()) {
            boolean removed = false;
            if (stack.has(ModDataComponents.UPGRADE_DATA)) {
                stack.remove(ModDataComponents.UPGRADE_DATA);
                removed = true;
            }
            if (stack.has(ModDataComponents.UPGRADE_ACTIVE)) {
                stack.remove(ModDataComponents.UPGRADE_ACTIVE);
                removed = true;
            }
            boolean bl = removed = removed || this.upgradeType.clearDataFromStack(stack);
            if (removed) {
                level.playLocalSound(player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, (level.random.nextFloat() - level.random.nextFloat()) * 0.35f + 0.9f, false);
                return InteractionResultHolder.success((Object)stack);
            }
        }
        return super.use(level, player, hand);
    }

    @Nonnull
    public InteractionResult onItemUseFirst(@Nonnull ItemStack stack, @Nonnull UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        Block block = state.getBlock();
        if (block instanceof IUpgradeableBlock) {
            IUpgradeableBlock block2 = (IUpgradeableBlock)block;
            IUpgradeable upgradeable = block2.getUpgradeable(level, pos, state);
            Player player = context.getPlayer();
            if (upgradeable == null || !block2.canUseUpgradeItem(upgradeable, stack, player)) {
                return InteractionResult.PASS;
            }
            if (upgradeable.quickInsertUpgrade(stack)) {
                return InteractionResult.SUCCESS;
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    public final boolean addsTooltips() {
        return this.addTooltips;
    }

    protected final void ignoreTooltips() {
        this.addTooltips = false;
    }

    protected final void setCustomTooltips(Function<UpgradeData, List<Component>> customTooltips) {
        this.customTooltips = customTooltips;
    }

    @Override
    @Nonnull
    public UpgradeType getUpgradeType() {
        return this.upgradeType;
    }

    @Override
    public abstract void setDefaultValues(@Nonnull UpgradeData.Mutable var1);

    @Nonnull
    public static UpgradeData getUpgradeData(@Nonnull ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof IUpgradeItem) {
            IUpgradeItem upgrade = (IUpgradeItem)item;
            UpgradeData.Mutable data = UpgradeData.EMPTY.makeMutable();
            upgrade.setDefaultValues(data);
            if (stack.has(ModDataComponents.UPGRADE_DATA)) {
                data.merge((UpgradeData)stack.get(ModDataComponents.UPGRADE_DATA));
            }
            return data.makeImmutable();
        }
        return UpgradeData.EMPTY;
    }

    public static List<Component> getUpgradeTooltip(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context) {
        try {
            return UpgradeItem.getUpgradeTooltip(stack, false, context);
        }
        catch (Throwable throwable) {
            return new ArrayList<Component>();
        }
    }

    public static List<Component> getUpgradeTooltip(@Nonnull ItemStack stack, boolean forceCollection, @Nonnull Item.TooltipContext context) {
        Item item = stack.getItem();
        if (item instanceof UpgradeItem) {
            List<Component> targets;
            UpgradeItem item2 = (UpgradeItem)item;
            if (!item2.addTooltips && !forceCollection) {
                return new ArrayList<Component>();
            }
            UpgradeType type = item2.getUpgradeType();
            UpgradeData data = UpgradeItem.getUpgradeData(stack);
            if (item2.customTooltips != null) {
                return (List)item2.customTooltips.apply((Object)data);
            }
            ArrayList<Component> tooltip = new ArrayList<Component>(type.getTooltip(data));
            tooltip.addAll(type.getTooltipWithContext(data, context));
            if (type.isUnique()) {
                tooltip.add((Component)LCText.TOOLTIP_UPGRADE_UNIQUE.getWithStyle(ChatFormatting.BOLD, ChatFormatting.GOLD));
            }
            if (!(targets = type.getPossibleTargets()).isEmpty()) {
                tooltip.add((Component)LCText.TOOLTIP_UPGRADE_TARGETS.getWithStyle(ChatFormatting.GRAY));
                for (Component target : targets) {
                    MutableComponent mc = EasyText.makeMutable(target);
                    tooltip.add((Component)mc.withStyle(ChatFormatting.GRAY));
                }
            }
            return tooltip;
        }
        return Lists.newArrayList();
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        List<Component> upgradeTooltips = UpgradeItem.getUpgradeTooltip(stack, context);
        if (upgradeTooltips != null) {
            tooltip.addAll(upgradeTooltips);
        }
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    public static boolean noUniqueConflicts(@Nonnull UpgradeItem item, @Nonnull Container container) {
        UpgradeType type = item.getUpgradeType();
        if (type.isUnique()) {
            for (int i = 0; i < container.getContainerSize(); ++i) {
                UpgradeItem otherItem;
                Item item2;
                ItemStack stack = container.getItem(i);
                if (stack.isEmpty() || !((item2 = stack.getItem()) instanceof UpgradeItem) || (otherItem = (UpgradeItem)item2).getUpgradeType() != type) continue;
                return false;
            }
        }
        return true;
    }

    public static class Simple
    extends UpgradeItem {
        public Simple(UpgradeType upgradeType, Item.Properties properties) {
            super(upgradeType, properties);
        }

        @Override
        public void setDefaultValues(@Nonnull UpgradeData.Mutable data) {
        }
    }
}

