/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public record FilterData(List<ResourceLocation> entries, List<ResourceLocation> tags) {
    public static final FilterData EMPTY = new FilterData((List<ResourceLocation>)ImmutableList.of(), (List<ResourceLocation>)ImmutableList.of());
    public static final Codec<FilterData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.CODEC.listOf().fieldOf("entries").forGetter(FilterData::entries), (App)ResourceLocation.CODEC.listOf().fieldOf("tags").forGetter(FilterData::tags)).apply((Applicative)builder, FilterData::new));
    public static final StreamCodec<FriendlyByteBuf, FilterData> STREAM_CODEC = StreamCodec.of((b, d) -> {
        b.writeInt(d.entries.size());
        for (ResourceLocation e : d.entries) {
            b.writeResourceLocation(e);
        }
        b.writeInt(d.tags.size());
        for (ResourceLocation t : d.tags) {
            b.writeResourceLocation(t);
        }
    }, b -> {
        int count = b.readInt();
        ArrayList<ResourceLocation> entries = new ArrayList<ResourceLocation>();
        while (count-- > 0) {
            entries.add(b.readResourceLocation());
        }
        count = b.readInt();
        ArrayList<ResourceLocation> tags = new ArrayList<ResourceLocation>();
        while (count-- > 0) {
            tags.add(b.readResourceLocation());
        }
        return new FilterData((List<ResourceLocation>)ImmutableList.copyOf(entries), (List<ResourceLocation>)ImmutableList.copyOf(tags));
    });

    public boolean isEmpty() {
        return this.entries.isEmpty() && this.tags.isEmpty();
    }

    public FilterData addEntry(ResourceLocation entry) {
        if (this.entries.contains(entry)) {
            return this;
        }
        ArrayList<ResourceLocation> newEntries = new ArrayList<ResourceLocation>(this.entries);
        newEntries.add(entry);
        return new FilterData((List<ResourceLocation>)ImmutableList.copyOf(newEntries), this.tags);
    }

    public FilterData removeEntry(ResourceLocation entry) {
        if (!this.entries.contains(entry)) {
            return this;
        }
        ArrayList<ResourceLocation> newEntries = new ArrayList<ResourceLocation>(this.entries);
        newEntries.remove(entry);
        return new FilterData((List<ResourceLocation>)ImmutableList.copyOf(newEntries), this.tags);
    }

    public FilterData addTag(ResourceLocation entry) {
        if (this.tags.contains(entry)) {
            return this;
        }
        ArrayList<ResourceLocation> newTags = new ArrayList<ResourceLocation>(this.tags);
        newTags.add(entry);
        return new FilterData(this.entries, (List<ResourceLocation>)ImmutableList.copyOf(newTags));
    }

    public FilterData removeTag(ResourceLocation entry) {
        if (!this.tags.contains(entry)) {
            return this;
        }
        ArrayList<ResourceLocation> newTags = new ArrayList<ResourceLocation>(this.tags);
        newTags.remove(entry);
        return new FilterData(this.entries, (List<ResourceLocation>)ImmutableList.copyOf(newTags));
    }

    public Predicate<ItemStack> asItemPredicate() {
        return s -> {
            ResourceLocation itemKey = BuiltInRegistries.ITEM.getKey((Object)s.getItem());
            if (this.entries.contains(itemKey)) {
                return true;
            }
            return s.getTags().anyMatch(tagKey -> this.tags.contains(tagKey.location()));
        };
    }

    public Predicate<FluidStack> asFluidPredicate() {
        return s -> {
            ResourceLocation fluidKey = BuiltInRegistries.FLUID.getKey((Object)s.getFluid());
            if (this.entries.contains(fluidKey)) {
                return true;
            }
            return BuiltInRegistries.FLUID.createIntrusiveHolder((Object)s.getFluid()).tags().anyMatch(tagKey -> this.tags.contains(tagKey.location()));
        };
    }
}

