/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.loot;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.StringListOption;
import io.github.lightman314.lightmanscurrency.api.events.DroplistConfigGenerator;
import io.github.lightman314.lightmanscurrency.common.loot.modifier.ILootModifier;
import io.github.lightman314.lightmanscurrency.common.loot.tiers.ChestPoolLevel;
import io.github.lightman314.lightmanscurrency.common.loot.tiers.EntityPoolLevel;
import io.github.lightman314.lightmanscurrency.integration.alexsmobs.LCAlexsMobs;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@EventBusSubscriber
public class LootManager {
    public static final LootContextParamSet ENTITY_PARAMS = new LootContextParamSet.Builder().optional(LootContextParams.ATTACKING_ENTITY).required(LootContextParams.DAMAGE_SOURCE).build();
    private static final List<ILootModifier> LOOT_MODIFIERS = new ArrayList<ILootModifier>();

    public static void init() {
        LCConfig.COMMON.addListener(LootManager::debugLootConfigs);
        LootContextParamSets.REGISTRY.put((Object)VersionUtil.lcResource("entity_addon"), (Object)ENTITY_PARAMS);
    }

    public static void addLootModifier(@Nonnull ILootModifier modifier) {
        if (!LOOT_MODIFIERS.contains(modifier)) {
            LOOT_MODIFIERS.add(modifier);
        }
    }

    public static void removeLootModifier(@Nonnull ILootModifier modifier) {
        LOOT_MODIFIERS.remove(modifier);
    }

    public static void registerDroplistListeners() {
        DroplistConfigGenerator.registerEntityListener(LootManager::AddDefaultEntityEntries);
        DroplistConfigGenerator.registerChestListener(LootManager::AddDefaultChestEntries);
        LCAlexsMobs.registerDroplistListeners();
    }

    public static MobSpawnType deserializeSpawnReason(String reasonString) {
        return LootManager.deserializeSpawnReason(reasonString, MobSpawnType.NATURAL);
    }

    public static MobSpawnType deserializeSpawnReason(String reasonString, MobSpawnType defaultReason) {
        for (MobSpawnType reason : MobSpawnType.values()) {
            if (!reason.toString().contentEquals(reasonString)) continue;
            return reason;
        }
        LightmansCurrency.LogWarning("Reason string \"" + reasonString + "\" could not be properly deserialized. Returning the default spawn reason.");
        return defaultReason;
    }

    public static void AddDefaultEntityEntries(DroplistConfigGenerator.Entity event) {
        switch (event.getTier()) {
            case T1: {
                event.addVanillaEntry("slime");
                event.addVanillaEntry("silverfish");
                break;
            }
            case T2: {
                event.addVanillaEntry("zombie");
                event.addVanillaEntry("skeleton");
                event.addVanillaEntry("creeper");
                event.addVanillaEntry("spider");
                event.addVanillaEntry("cave_spider");
                event.addVanillaEntry("husk");
                event.addVanillaEntry("stray");
                event.addVanillaEntry("zombie_villager");
                event.addVanillaEntry("drowned");
                break;
            }
            case T3: {
                event.addVanillaEntry("guardian");
                event.addVanillaEntry("elder_guardian");
                event.addVanillaEntry("phantom");
                event.addVanillaEntry("blaze");
                event.addVanillaEntry("ghast");
                event.addVanillaEntry("hoglin");
                event.addVanillaEntry("piglin_brute");
                event.addVanillaEntry("piglin");
                event.addVanillaEntry("zombified_piglin");
                break;
            }
            case T4: {
                event.addVanillaEntry("enderman");
                event.addVanillaEntry("shulker");
                event.addTag("raiders");
                break;
            }
            case T5: {
                event.addVanillaEntry("wither_skeleton");
                break;
            }
            case BOSS_T4: {
                event.addVanillaEntry("warden");
                break;
            }
            case BOSS_T5: {
                event.addVanillaEntry("ender_dragon");
                break;
            }
            case BOSS_T6: {
                event.addVanillaEntry("wither");
            }
        }
    }

    public static void AddDefaultChestEntries(DroplistConfigGenerator.Chest event) {
        LightmansCurrency.LogDebug("Adding default vanilla chest entries of tier '" + event.getTier().toString() + "'");
        switch (event.getTier()) {
            case T1: {
                event.addVanillaEntry("underwater_ruin_small");
                event.addVanillaEntry("underwater_ruin_big");
                break;
            }
            case T3: {
                event.addVanillaEntry("jungle_temple");
                event.addVanillaEntry("nether_bridge");
                event.addVanillaEntry("simple_dungeon");
                event.addVanillaEntry("ruined_portal");
                break;
            }
            case T4: {
                event.addVanillaEntry("stronghold_crossing");
                event.addVanillaEntry("stronghold_corridor");
                event.addVanillaEntry("stronghold_library");
                event.addVanillaEntry("ancient_city");
                break;
            }
            case T5: {
                event.addVanillaEntry("buried_treasure");
                event.addVanillaEntry("bastion_hoglin_stable");
                event.addVanillaEntry("bastion_bridge");
                event.addVanillaEntry("bastion_other");
                event.addVanillaEntry("bastion_treasure");
                event.addVanillaEntry("end_city_treasure");
            }
        }
    }

    private static String getValueList(StringListOption config) {
        StringBuilder buffer = new StringBuilder();
        List list = (List)config.get();
        for (String value : list) {
            if (!buffer.isEmpty()) {
                buffer.append(", ");
            }
            buffer.append("\"").append(value).append("\"");
        }
        return buffer.toString();
    }

    public static void debugLootConfigs() {
        LightmansCurrency.LogDebug("Lightman's Currency common configs have been loaded. Coin loot values are as follows.");
        LightmansCurrency.LogDebug("Chest T1: " + LootManager.getValueList(LCConfig.COMMON.chestDropsT1));
        LightmansCurrency.LogDebug("Chest T2: " + LootManager.getValueList(LCConfig.COMMON.chestDropsT2));
        LightmansCurrency.LogDebug("Chest T3: " + LootManager.getValueList(LCConfig.COMMON.chestDropsT3));
        LightmansCurrency.LogDebug("Chest T4: " + LootManager.getValueList(LCConfig.COMMON.chestDropsT4));
        LightmansCurrency.LogDebug("Chest T5: " + LootManager.getValueList(LCConfig.COMMON.chestDropsT5));
        LightmansCurrency.LogDebug("Chest T6: " + LootManager.getValueList(LCConfig.COMMON.chestDropsT6));
        LightmansCurrency.LogDebug("Entity T1: " + LootManager.getValueList(LCConfig.COMMON.entityDropsT1));
        LightmansCurrency.LogDebug("Entity T2: " + LootManager.getValueList(LCConfig.COMMON.entityDropsT2));
        LightmansCurrency.LogDebug("Entity T3: " + LootManager.getValueList(LCConfig.COMMON.entityDropsT3));
        LightmansCurrency.LogDebug("Entity T4: " + LootManager.getValueList(LCConfig.COMMON.entityDropsT4));
        LightmansCurrency.LogDebug("Entity T5: " + LootManager.getValueList(LCConfig.COMMON.entityDropsT5));
        LightmansCurrency.LogDebug("Entity T6: " + LootManager.getValueList(LCConfig.COMMON.entityDropsT6));
        LightmansCurrency.LogDebug("Boss Entity T1: " + LootManager.getValueList(LCConfig.COMMON.bossEntityDropsT1));
        LightmansCurrency.LogDebug("Boss Entity T2: " + LootManager.getValueList(LCConfig.COMMON.bossEntityDropsT2));
        LightmansCurrency.LogDebug("Boss Entity T3: " + LootManager.getValueList(LCConfig.COMMON.bossEntityDropsT3));
        LightmansCurrency.LogDebug("Boss Entity T4: " + LootManager.getValueList(LCConfig.COMMON.bossEntityDropsT4));
        LightmansCurrency.LogDebug("Boss Entity T5: " + LootManager.getValueList(LCConfig.COMMON.bossEntityDropsT5));
        LightmansCurrency.LogDebug("Boss Entity T6: " + LootManager.getValueList(LCConfig.COMMON.bossEntityDropsT6));
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        EntityPoolLevel poolLevel;
        Mob mob;
        LivingEntity entity = event.getEntity();
        if (entity.level().isClientSide) {
            return;
        }
        if (!((Boolean)LCConfig.COMMON.allowSpawnerEntityDrops.get()).booleanValue() && entity instanceof Mob && (mob = (Mob)entity).getSpawnType() == MobSpawnType.SPAWNER) {
            LightmansCurrency.LogDebug(entity.getName().getString() + " did not drop coins, as it was spawned by a spawner.");
            return;
        }
        Player player = null;
        if (event.getSource().getDirectEntity() instanceof Player || event.getSource().getEntity() instanceof Player) {
            Player p;
            Entity entity2 = event.getSource().getDirectEntity();
            Player player2 = player = entity2 instanceof Player ? (p = (Player)entity2) : (Player)event.getSource().getEntity();
            if (player instanceof FakePlayer && !((Boolean)LCConfig.COMMON.allowFakePlayerCoinDrops.get()).booleanValue()) {
                return;
            }
        }
        if ((poolLevel = LootManager.GetEntityPoolLevel(entity.getType())) != null) {
            LootManager.DropEntityLoot((Entity)entity, player, poolLevel, event.getSource());
        }
    }

    private static String getSafeId(@Nonnull Entity entity) {
        ResourceLocation id = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        return id.toString().replace(':', '_');
    }

    public static List<ItemStack> safelyGetLoot(LootTable table, LootContext context) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        table.getRandomItemsRaw(context, results::add);
        return results;
    }

    public static List<ItemStack> getLoot(@Nonnull ResourceLocation lootTable, @Nonnull LootContext context) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return results;
        }
        LootTable table = server.reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTable));
        List<ItemStack> loot = LootManager.safelyGetLoot(table, context);
        LootManager.checkForEventReplacements(server, loot);
        return loot;
    }

    public static void checkForEventReplacements(@Nonnull MinecraftServer server, @Nonnull List<ItemStack> loot) {
        RandomSource random = server.overworld().getRandom();
        for (ILootModifier modifier : LOOT_MODIFIERS) {
            if (!modifier.tryModifyLoot(random, loot)) continue;
            return;
        }
    }

    private static void DropEntityLoot(@Nonnull Entity entity, @Nullable Player player, @Nonnull EntityPoolLevel coinPool, @Nonnull DamageSource damageSource) {
        if (!((Boolean)LCConfig.COMMON.enableEntityDrops.get()).booleanValue()) {
            return;
        }
        if (!coinPool.isBoss && player == null) {
            return;
        }
        LootContext context = LootManager.generateEntityContext(entity, player, damageSource);
        InventoryUtil.dumpContents(entity.level(), entity.blockPosition(), LootManager.getLoot(coinPool.lootTable, context));
    }

    public static LootContext generateEntityContext(@Nonnull Entity entity, @Nullable Player player, @Nonnull DamageSource damageSource) {
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            throw new IllegalArgumentException("Function must be run on the server side!");
        }
        ServerLevel level2 = (ServerLevel)level;
        LootParams.Builder parameterBuilder = new LootParams.Builder(level2);
        if (player != null) {
            parameterBuilder.withParameter(LootContextParams.ATTACKING_ENTITY, (Object)player);
        }
        parameterBuilder.withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource);
        LootParams params = parameterBuilder.create(ENTITY_PARAMS);
        return new LootContext.Builder(params).create(Optional.empty());
    }

    @Nullable
    public static ChestPoolLevel GetChestPoolLevel(@Nonnull String lootTable) {
        if (((List)LCConfig.COMMON.chestDropsT1.get()).contains(lootTable)) {
            return ChestPoolLevel.T1;
        }
        if (((List)LCConfig.COMMON.chestDropsT2.get()).contains(lootTable)) {
            return ChestPoolLevel.T2;
        }
        if (((List)LCConfig.COMMON.chestDropsT3.get()).contains(lootTable)) {
            return ChestPoolLevel.T3;
        }
        if (((List)LCConfig.COMMON.chestDropsT4.get()).contains(lootTable)) {
            return ChestPoolLevel.T4;
        }
        if (((List)LCConfig.COMMON.chestDropsT5.get()).contains(lootTable)) {
            return ChestPoolLevel.T5;
        }
        if (((List)LCConfig.COMMON.chestDropsT6.get()).contains(lootTable)) {
            return ChestPoolLevel.T6;
        }
        return null;
    }

    @Nullable
    public static EntityPoolLevel GetEntityPoolLevel(@Nonnull EntityType<?> entity) {
        if (LootManager.ConfigContainsEntity(LCConfig.COMMON.entityDropsT1, entity)) {
            return EntityPoolLevel.T1;
        }
        if (LootManager.ConfigContainsEntity(LCConfig.COMMON.entityDropsT2, entity)) {
            return EntityPoolLevel.T2;
        }
        if (LootManager.ConfigContainsEntity(LCConfig.COMMON.entityDropsT3, entity)) {
            return EntityPoolLevel.T3;
        }
        if (LootManager.ConfigContainsEntity(LCConfig.COMMON.entityDropsT4, entity)) {
            return EntityPoolLevel.T4;
        }
        if (LootManager.ConfigContainsEntity(LCConfig.COMMON.entityDropsT5, entity)) {
            return EntityPoolLevel.T5;
        }
        if (LootManager.ConfigContainsEntity(LCConfig.COMMON.entityDropsT6, entity)) {
            return EntityPoolLevel.T6;
        }
        if (LootManager.ConfigContainsEntity(LCConfig.COMMON.bossEntityDropsT1, entity)) {
            return EntityPoolLevel.BOSS_T1;
        }
        if (LootManager.ConfigContainsEntity(LCConfig.COMMON.bossEntityDropsT2, entity)) {
            return EntityPoolLevel.BOSS_T2;
        }
        if (LootManager.ConfigContainsEntity(LCConfig.COMMON.bossEntityDropsT3, entity)) {
            return EntityPoolLevel.BOSS_T3;
        }
        if (LootManager.ConfigContainsEntity(LCConfig.COMMON.bossEntityDropsT4, entity)) {
            return EntityPoolLevel.BOSS_T4;
        }
        if (LootManager.ConfigContainsEntity(LCConfig.COMMON.bossEntityDropsT5, entity)) {
            return EntityPoolLevel.BOSS_T5;
        }
        if (LootManager.ConfigContainsEntity(LCConfig.COMMON.bossEntityDropsT6, entity)) {
            return EntityPoolLevel.BOSS_T6;
        }
        return null;
    }

    public static boolean ConfigContainsEntity(@Nonnull StringListOption configOption, @Nonnull EntityType<?> entityType) {
        ResourceLocation entityID = BuiltInRegistries.ENTITY_TYPE.getKey(entityType);
        if (entityID == null) {
            return false;
        }
        Stream entityTags = entityType.getTags();
        for (String option : (List)configOption.get()) {
            try {
                ResourceLocation tagKey;
                if (!(option.startsWith("#") ? entityTags.anyMatch(arg_0 -> LootManager.lambda$ConfigContainsEntity$0(tagKey = VersionUtil.parseResource(option.substring(1)), arg_0)) : (option.endsWith(":*") ? VersionUtil.parseResource(option.replace(":*", ":null")).getNamespace().equals(entityID.getNamespace()) : VersionUtil.parseResource(option).equals((Object)entityID)))) continue;
                return true;
            }
            catch (ResourceLocationException resourceLocationException) {
            }
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$ConfigContainsEntity$0(ResourceLocation tagKey, TagKey tag) {
        return tag.location().equals((Object)tagKey);
    }
}

