/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menus.LazyMessageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.containers.SuppliedContainer;
import io.github.lightman314.lightmanscurrency.common.menus.slots.DisplaySlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasySlot;
import io.github.lightman314.lightmanscurrency.common.playertrading.IPlayerTrade;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerTradeMenu
extends LazyMessageMenu {
    private static final Logger LOGGER = LogManager.getLogger();
    public final int tradeID;
    private IPlayerTrade trade;
    public final Player player;
    private Consumer<Component> chatReceiver = c -> {};

    public final IPlayerTrade getTradeData() {
        return this.trade;
    }

    public final boolean isHost() {
        return this.trade.isHost(this.player);
    }

    public final int myState() {
        return this.isHost() ? this.trade.getHostState() : this.trade.getGuestState();
    }

    public final int otherState() {
        return this.isHost() ? this.trade.getGuestState() : this.trade.getHostState();
    }

    public final void setChatReceiver(@Nonnull Consumer<Component> chatReceiver) {
        this.chatReceiver = chatReceiver;
    }

    public void hideSlots() {
        EasySlot.SetInactive(this);
    }

    public void showSlots() {
        EasySlot.SetActive(this);
    }

    public PlayerTradeMenu(int windowID, Inventory inventory, int tradeID, IPlayerTrade trade) {
        super(ModMenus.PLAYER_TRADE.get(), windowID, inventory);
        int x;
        int y;
        this.player = inventory.player;
        this.tradeID = tradeID;
        this.trade = trade;
        SuppliedContainer hostItems = new SuppliedContainer(() -> this.getTradeData().getHostItems());
        SuppliedContainer guestItems = new SuppliedContainer(() -> this.getTradeData().getGuestItems());
        SuppliedContainer leftSideContainer = this.isHost() ? hostItems : guestItems;
        SuppliedContainer rightSideContainer = this.isHost() ? guestItems : hostItems;
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 3; ++x) {
                this.addSlot(new EasySlot(leftSideContainer, x + y * 3, 8 + x * 18, 30 + y * 18));
            }
        }
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 3; ++x) {
                this.addSlot(new DisplaySlot(rightSideContainer, x + y * 3, 116 + x * 18, 30 + y * 18));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 140 + y * 18));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            this.addSlot(new Slot((Container)inventory, x2, 8 + x2 * 18, 198));
        }
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int index) {
        ItemStack clickedStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            clickedStack = slotStack.copy();
            if (index < 12 ? !this.moveItemStackTo(slotStack, 24, this.slots.size(), true) : !this.moveItemStackTo(slotStack, 0, 12, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return clickedStack;
    }

    public void removed(@Nonnull Player player) {
        super.removed(player);
        if (this.isClient() || this.trade.isCompleted()) {
            return;
        }
        LightmansCurrency.LogWarning("Player Trade Menu was closed by the " + (this.isHost() ? "host" : "guest") + ", but the trade was not completed!");
        this.clearContainer(player, this.trade.isHost(this.player) ? this.trade.getHostItems() : this.trade.getGuestItems());
    }

    public MoneyView getAvailableFunds() {
        return MoneyAPI.getApi().GetPlayersMoneyHandler(this.player).getStoredMoney();
    }

    public void onTradeChange() {
    }

    public final void reloadTrade(IPlayerTrade trade) {
        if (this.isClient()) {
            this.trade = trade;
            this.onTradeChange();
        } else {
            LightmansCurrency.LogWarning("Attempted to reload the trade on the server-side menu.");
        }
    }

    public void SendChatToServer(@Nonnull String message) {
        this.SendMessageToServer(this.builder().setString("AddChat", message));
    }

    @Override
    public void HandleMessage(@Nonnull LazyPacketData message) {
        IPlayerTrade trade;
        if (message.contains("AddChat") && this.isServer() && (trade = this.getTradeData()) != null) {
            MutableComponent m = EasyText.literal("<").append(this.player.getName()).append("> ").append(message.getString("AddChat"));
            LOGGER.info("Private Chat: " + m.getString());
            this.SendChatTo(trade.getHostID(), (Component)m);
            this.SendChatTo(trade.getGuestID(), (Component)m);
        }
        if (message.contains("ReceiveChat") && this.chatReceiver != null) {
            this.chatReceiver.accept(message.getText("ReceiveChat"));
        }
    }

    private void SendChatTo(@Nonnull UUID id, @Nonnull Component message) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        ServerPlayer player = server.getPlayerList().getPlayer(id);
        if (player == null) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof PlayerTradeMenu) {
            PlayerTradeMenu menu = (PlayerTradeMenu)abstractContainerMenu;
            menu.SendMessage(this.builder().setText("ReceiveChat", message));
        }
    }
}

