/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage.auction;

import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.auction.AuctionCreateClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasySlot;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AuctionCreateTab
extends TraderStorageTab {
    List<EasySlot> slots = new ArrayList<EasySlot>();
    SimpleContainer auctionItems = new SimpleContainer(2);

    public AuctionCreateTab(@Nonnull ITraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(@Nonnull Object screen) {
        return new AuctionCreateClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return true;
    }

    public List<EasySlot> getSlots() {
        return this.slots;
    }

    public SimpleContainer getAuctionItems() {
        return this.auctionItems;
    }

    @Override
    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
        for (int i = 0; i < this.auctionItems.getContainerSize(); ++i) {
            EasySlot newSlot = new EasySlot((Container)this.auctionItems, i, 23 + i * 18, 122);
            addSlot.apply(newSlot);
            this.slots.add(newSlot);
        }
        EasySlot.SetActive(this.slots, false);
    }

    @Override
    public void onTabOpen() {
        EasySlot.SetActive(this.slots);
        for (EasySlot slot : this.slots) {
            slot.locked = false;
        }
    }

    @Override
    public void onTabClose() {
        EasySlot.SetInactive(this.slots);
        ((ITraderStorageMenu)this.menu).clearContainer((Container)this.auctionItems);
    }

    @Override
    public void onMenuClose() {
        ((ITraderStorageMenu)this.menu).clearContainer((Container)this.auctionItems);
    }

    public void createAuction(AuctionTradeData trade) {
        TraderData t = ((ITraderStorageMenu)this.menu).getTrader();
        if (t instanceof AuctionHouseTrader) {
            AuctionHouseTrader trader = (AuctionHouseTrader)t;
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setCompound("CreateAuction", trade.getAsNBT((HolderLookup.Provider)this.registryAccess())));
                return;
            }
            trade.setAuctionItems((Container)this.auctionItems);
            if (!trade.isValid()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setBoolean("AuctionCreated", false));
                return;
            }
            boolean success = trader.addTrade(trade, ((ITraderStorageMenu)this.menu).getPlayer(), false);
            if (success) {
                this.auctionItems.clearContent();
            }
            ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setBoolean("AuctionCreated", success));
            for (EasySlot slot : this.slots) {
                slot.locked = true;
            }
        }
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("CreateAuction")) {
            this.createAuction(new AuctionTradeData(message.getNBT("CreateAuction"), message.lookup));
        }
    }
}

