/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EquipmentRestriction
extends ItemTradeRestriction {
    private final EquipmentSlot equipmentType;
    public static final EquipmentRestriction HEAD = new EquipmentRestriction(EquipmentSlot.HEAD);
    public static final EquipmentRestriction CHEST = new EquipmentRestriction(EquipmentSlot.CHEST);
    public static final EquipmentRestriction LEGS = new EquipmentRestriction(EquipmentSlot.LEGS);
    public static final EquipmentRestriction FEET = new EquipmentRestriction(EquipmentSlot.FEET);

    protected EquipmentRestriction(EquipmentSlot type) {
        this.equipmentType = type;
    }

    public EquipmentSlot getEquipmentSlot() {
        return this.equipmentType;
    }

    @Override
    public boolean allowSellItem(ItemStack itemStack) {
        return this.equippable(itemStack);
    }

    @Override
    public boolean allowItemSelectItem(ItemStack itemStack) {
        return this.equippable(itemStack);
    }

    @Override
    public Predicate<ItemStack> modifyFilter(Predicate<ItemStack> filter) {
        return item -> this.allowSellItem((ItemStack)item) && filter.test((ItemStack)item);
    }

    private boolean equippable(ItemStack item) {
        try {
            return item.canEquip(this.equipmentType, (LivingEntity)EquipmentRestriction.safeGetDummyArmorStand()) || this.vanillaEquippable(item);
        }
        catch (Throwable e) {
            return this.vanillaEquippable(item);
        }
    }

    private boolean vanillaEquippable(ItemStack item) {
        try {
            Equipable equipable = Equipable.get((ItemStack)item);
            if (equipable != null) {
                return equipable.getEquipmentSlot() == this.equipmentType;
            }
            return false;
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error attempting to get equipment slot for " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)item.getItem())) + "!", t);
            return false;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Pair<ResourceLocation, ResourceLocation> getEmptySlotBG() {
        return switch (this.equipmentType) {
            case EquipmentSlot.HEAD -> Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_HELMET);
            case EquipmentSlot.CHEST -> Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE);
            case EquipmentSlot.LEGS -> Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS);
            case EquipmentSlot.FEET -> Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS);
            case EquipmentSlot.OFFHAND -> Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
            default -> null;
        };
    }

    private static ArmorStand safeGetDummyArmorStand() throws Exception {
        return new ArmorStand(LightmansCurrency.getProxy().safeGetDummyLevel(), 0.0, 0.0, 0.0);
    }
}

