/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.ejection.SafeEjectionAPI;
import io.github.lightman314.lightmanscurrency.api.ejection.builtin.BasicEjectionData;
import io.github.lightman314.lightmanscurrency.api.misc.player.OwnerData;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.PlayerOwner;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.coin_chest.SecurityUpgradeTab;
import io.github.lightman314.lightmanscurrency.common.blockentity.CoinChestBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.menus.CoinChestMenu;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgradeData;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.data.SecurityUpgradeData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CoinChestSecurityUpgrade
extends CoinChestUpgrade {
    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public boolean alwayActive() {
        return true;
    }

    @Override
    public void HandleMenuMessage(@Nonnull CoinChestMenu menu, @Nonnull CoinChestUpgradeData data, @Nonnull LazyPacketData message) {
        PlayerReference player;
        if (message.contains("SetOwner")) {
            Owner owner = message.getOwner("SetOwner");
            if (owner != null) {
                OwnerData ownerData = this.parseOwnerData(menu.be, data);
                ownerData.SetOwner(owner);
                this.saveOwnerData(menu.be, data, ownerData);
            }
        } else if (message.contains("SetPlayerOwner") && (player = PlayerReference.of(false, message.getString("SetPlayerOwner"))) != null) {
            OwnerData owner = this.parseOwnerData(menu.be, data);
            owner.SetOwner(PlayerOwner.of(player));
            this.saveOwnerData(menu.be, data, owner);
        }
    }

    public boolean isAdmin(CoinChestBlockEntity be, CoinChestUpgradeData data, Player player) {
        OwnerData owner = this.parseOwnerData(be, data);
        if (owner.hasOwner()) {
            return owner.isAdmin(player);
        }
        return true;
    }

    public boolean isMember(CoinChestBlockEntity be, CoinChestUpgradeData data, Player player) {
        OwnerData owner = this.parseOwnerData(be, data);
        if (owner.hasOwner()) {
            return owner.isMember(player);
        }
        return true;
    }

    @Nonnull
    public OwnerData parseOwnerData(CoinChestBlockEntity be, CoinChestUpgradeData data) {
        return data.getData(ModDataComponents.SECURITY_UPGRADE_DATA, SecurityUpgradeData.DEFAULT).owner.withParent(be);
    }

    public void saveOwnerData(@Nonnull CoinChestBlockEntity be, CoinChestUpgradeData data, OwnerData newOwner) {
        data.editData(ModDataComponents.SECURITY_UPGRADE_DATA, SecurityUpgradeData.DEFAULT, d -> d.withOwner(newOwner));
    }

    @Override
    public boolean BlockAccess(@Nonnull CoinChestBlockEntity be, @Nonnull CoinChestUpgradeData data, @Nullable Player player) {
        return player == null || !this.isMember(be, data, player);
    }

    @Override
    public void OnEquip(@Nonnull CoinChestBlockEntity be, @Nonnull CoinChestUpgradeData data) {
        data.editData(ModDataComponents.SECURITY_UPGRADE_DATA, SecurityUpgradeData.DEFAULT, d -> d.withBreakIsValid(false));
    }

    @Override
    public void OnValidBlockRemoval(@Nonnull CoinChestBlockEntity be, @Nonnull CoinChestUpgradeData data) {
        data.editData(ModDataComponents.SECURITY_UPGRADE_DATA, SecurityUpgradeData.DEFAULT, d -> d.withBreakIsValid(true));
    }

    @Override
    public void OnBlockRemoval(@Nonnull CoinChestBlockEntity be, @Nonnull CoinChestUpgradeData data) {
        if (data.getData(ModDataComponents.SECURITY_UPGRADE_DATA, SecurityUpgradeData.DEFAULT).breakIsValid) {
            return;
        }
        OwnerData owner = this.parseOwnerData(be, data);
        if (owner.hasOwner()) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(be.getStorage().removeAllItems());
            items.addAll(be.getUpgrades().removeAllItems());
            SafeEjectionAPI.getApi().handleEjection(be.getLevel(), be.getBlockPos(), new BasicEjectionData(owner, (Container)InventoryUtil.buildInventory(items), be.getDisplayName()));
        }
    }

    @Override
    public void addClientTabs(@Nonnull CoinChestUpgradeData data, @Nonnull Object screen, @Nonnull Consumer<Object> consumer) {
        consumer.accept(new SecurityUpgradeTab(data, screen));
    }

    @Override
    @Nonnull
    public List<Component> getTooltip(@Nonnull UpgradeData data) {
        List<Component> tooltip = LCText.TOOLTIP_UPGRADE_SECURITY.get(new Object[0]);
        if (LCConfig.SERVER.isLoaded() && ((Boolean)LCConfig.SERVER.anarchyMode.get()).booleanValue()) {
            tooltip.add((Component)LCText.TOOLTIP_ANARCHY_WARNING.get(new Object[0]).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.RED));
        }
        return tooltip;
    }

    @Override
    public boolean clearDataFromStack(@Nonnull ItemStack stack) {
        return this.clearData(stack, ModDataComponents.SECURITY_UPGRADE_DATA);
    }
}

