/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.villager_merchant.listings;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.ItemListingSerializer;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.ListingUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class EnchantedItemForCoinsTrade
implements VillagerTrades.ItemListing {
    public static final ResourceLocation TYPE = VersionUtil.lcResource("enchanted_item_for_coins");
    public static final Serializer SERIALIZER = new Serializer();
    protected final Item baseCoin;
    protected final int baseCoinCount;
    protected final Item sellItem;
    protected final int maxTrades;
    protected final int xp;
    protected final float priceMult;
    protected final double basePriceModifier;

    public EnchantedItemForCoinsTrade(ItemLike baseCoin, int baseCoinCount, ItemLike sellItem, int maxUses, int xpValue, float priceMultiplier, double basePriceModifier) {
        this.baseCoin = baseCoin.asItem();
        this.baseCoinCount = baseCoinCount;
        this.basePriceModifier = basePriceModifier;
        this.sellItem = sellItem.asItem();
        this.maxTrades = maxUses;
        this.xp = xpValue;
        this.priceMult = priceMultiplier;
    }

    public MerchantOffer getOffer(@Nonnull Entity trader, @Nonnull RandomSource rand) {
        int i = 5 + rand.nextInt(15);
        ItemStack itemstack = EnchantmentHelper.enchantItem((RandomSource)rand, (ItemStack)new ItemStack((ItemLike)this.sellItem), (int)i, (Stream)trader.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(EnchantmentTags.ON_TRADED_EQUIPMENT).stream());
        ChainData chain = CoinAPI.getApi().ChainDataOfCoin(this.baseCoin);
        if (chain == null) {
            LightmansCurrency.LogWarning("Item for coin trade failed as '" + new ItemStack((ItemLike)this.baseCoin).getHoverName().getString() + "' is not a registered coin!");
            return null;
        }
        long coinValue = chain.getCoreValue(this.baseCoin);
        long baseValue = coinValue * (long)this.baseCoinCount;
        long priceValue = baseValue + (long)((double)(coinValue * (long)i) * this.basePriceModifier);
        ItemStack price1 = ItemStack.EMPTY;
        ItemStack price2 = ItemStack.EMPTY;
        MoneyValue v = CoinValue.fromNumber(chain.chain, priceValue);
        if (!(v instanceof CoinValue)) {
            return null;
        }
        CoinValue cv = (CoinValue)v;
        List<ItemStack> priceStacks = cv.getAsSeperatedItemList();
        if (!priceStacks.isEmpty()) {
            price1 = priceStacks.get(0);
        }
        if (priceStacks.size() > 1) {
            price2 = priceStacks.get(1);
        }
        return new MerchantOffer(ListingUtil.costFor(price1), ListingUtil.optionalCost(price2), itemstack, this.maxTrades, this.xp, this.priceMult);
    }

    public static class Serializer
    implements ItemListingSerializer.IItemListingSerializer,
    ItemListingSerializer.IItemListingDeserializer {
        private Serializer() {
        }

        @Override
        public ResourceLocation getType() {
            return TYPE;
        }

        @Override
        public JsonObject serializeInternal(@Nonnull JsonObject json, @Nonnull VillagerTrades.ItemListing trade, @Nonnull HolderLookup.Provider lookup) {
            if (trade instanceof EnchantedItemForCoinsTrade) {
                EnchantedItemForCoinsTrade t = (EnchantedItemForCoinsTrade)trade;
                json.addProperty("Coin", BuiltInRegistries.ITEM.getKey((Object)t.baseCoin).toString());
                json.addProperty("BaseCoinCount", (Number)t.baseCoinCount);
                json.addProperty("EnchantmentValueModifier", (Number)t.basePriceModifier);
                json.addProperty("Sell", BuiltInRegistries.ITEM.getKey((Object)t.sellItem).toString());
                json.addProperty("MaxTrades", (Number)t.maxTrades);
                json.addProperty("XP", (Number)t.xp);
                json.addProperty("PriceMult", (Number)Float.valueOf(t.priceMult));
                return json;
            }
            return null;
        }

        @Override
        @Nonnull
        public VillagerTrades.ItemListing deserialize(@Nonnull JsonObject json, @Nonnull HolderLookup.Provider lookup) throws JsonSyntaxException, ResourceLocationException {
            Item coin = (Item)BuiltInRegistries.ITEM.get(VersionUtil.parseResource(GsonHelper.getAsString((JsonObject)json, (String)"Coin")));
            int baseCoinCount = GsonHelper.getAsInt((JsonObject)json, (String)"BaseCoinCount");
            double basePriceModifier = GsonHelper.getAsDouble((JsonObject)json, (String)"EnchantmentValueModifier");
            Item sellItem = (Item)BuiltInRegistries.ITEM.get(VersionUtil.parseResource(GsonHelper.getAsString((JsonObject)json, (String)"Sell")));
            int maxTrades = GsonHelper.getAsInt((JsonObject)json, (String)"MaxTrades");
            int xp = GsonHelper.getAsInt((JsonObject)json, (String)"XP");
            float priceMult = GsonHelper.getAsFloat((JsonObject)json, (String)"PriceMult");
            return new EnchantedItemForCoinsTrade((ItemLike)coin, baseCoinCount, (ItemLike)sellItem, maxTrades, xp, priceMult, basePriceModifier);
        }
    }
}

