/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.configured;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.mods.VillagerTradeMod;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;

public class ConfiguredItemListing
implements VillagerTrades.ItemListing {
    final VillagerTrades.ItemListing tradeSource;
    final Supplier<VillagerTradeMod> modSupplier;

    public ConfiguredItemListing(@Nonnull VillagerTrades.ItemListing tradeSource, @Nonnull Supplier<VillagerTradeMod> modSupplier) {
        this.tradeSource = tradeSource;
        this.modSupplier = modSupplier;
    }

    public MerchantOffer getOffer(@Nonnull Entity trader, @Nonnull RandomSource random) {
        try {
            boolean attempts = false;
            MerchantOffer offer = this.tradeSource.getOffer(trader, random);
            if (offer == null) {
                return null;
            }
            assert (offer != null);
            VillagerTradeMod mod = this.modSupplier.get();
            ItemCost itemA = mod.modifyCost(trader, offer.getItemCostA());
            Optional<ItemCost> itemB = offer.getItemCostB();
            if (itemB.isPresent()) {
                itemB = Optional.of(mod.modifyCost(trader, (ItemCost)itemB.get()));
            }
            ItemStack itemC = mod.modifyResult(trader, offer.getResult());
            return new MerchantOffer(itemA, itemB, itemC, offer.getUses(), offer.getMaxUses(), offer.getXp(), offer.getPriceMultiplier(), offer.getDemand());
        }
        catch (Throwable t) {
            LightmansCurrency.LogWarning("Error converting trade:", t);
            return null;
        }
    }
}

