/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.common.tags;

import com.simibubi.create.AllBlocks;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBiBundle;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBundle;
import io.github.lightman314.lightmanscurrency.common.core.variants.IOptionalKey;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class LCItemTagProvider
extends ItemTagsProvider {
    public LCItemTagProvider(@Nonnull PackOutput output, @Nonnull CompletableFuture<HolderLookup.Provider> lookupProvider, @Nonnull CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTagProvider, "lightmanscurrency", existingFileHelper);
    }

    protected void addTags(@Nonnull HolderLookup.Provider lookup) {
        this.cTag(LCTags.Items.COINS).addTag(LCTags.Items.EVENT_COINS).add(ModItems.COIN_COPPER).add(ModItems.COIN_IRON).add(ModItems.COIN_GOLD).add(ModItems.COIN_EMERALD).add(ModItems.COIN_DIAMOND).add(ModItems.COIN_NETHERITE).add(ModItems.COIN_ANCIENT);
        this.cTag(LCTags.Items.EVENT_COINS).addTag(LCTags.Items.EVENT_COIN_CHOCOLATE);
        this.cTag(LCTags.Items.EVENT_COIN_CHOCOLATE).add(ModItems.COIN_CHOCOLATE_COPPER).add(ModItems.COIN_CHOCOLATE_IRON).add(ModItems.COIN_CHOCOLATE_GOLD).add(ModItems.COIN_CHOCOLATE_EMERALD).add(ModItems.COIN_CHOCOLATE_DIAMOND).add(ModItems.COIN_CHOCOLATE_NETHERITE);
        this.cTag(LCTags.Items.COIN_MINTING_MATERIAL).addTag((TagKey<Item>)Tags.Items.INGOTS_COPPER).addTag((TagKey<Item>)Tags.Items.INGOTS_IRON).addTag((TagKey<Item>)Tags.Items.INGOTS_GOLD).addTag((TagKey<Item>)Tags.Items.GEMS_EMERALD).addTag((TagKey<Item>)Tags.Items.GEMS_DIAMOND).addTag((TagKey<Item>)Tags.Items.INGOTS_NETHERITE);
        this.cTag(LCTags.Items.WALLET).add(ModItems.WALLET_LEATHER).add(ModItems.WALLET_COPPER).add(ModItems.WALLET_IRON).add(ModItems.WALLET_GOLD).add(ModItems.WALLET_EMERALD).add(ModItems.WALLET_DIAMOND).add(ModItems.WALLET_NETHERITE).add(ModItems.WALLET_NETHER_STAR).add(ModItems.WALLET_ENDER_DRAGON);
        this.cTag(LCTags.Items.WALLET_UPGRADE_MATERIAL).addTag((TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        this.cTag(LCTags.Items.TRADER).addTag(LCTags.Items.TRADER_NORMAL).addTag(LCTags.Items.TRADER_SPECIALTY).addTag(LCTags.Items.TRADER_NETWORK).add((ItemLike)ModBlocks.COMMAND_TRADER.get());
        this.cTag(LCTags.Items.TRADER_NORMAL).addTag(LCTags.Items.TRADER_DISPLAY_CASE).addTag(LCTags.Items.TRADER_VENDING_MACHINE).addTag(LCTags.Items.TRADER_LARGE_VENDING_MACHINE).addTag(LCTags.Items.TRADER_SHELF).addTag(LCTags.Items.TRADER_SHELF_2x2).addTag(LCTags.Items.TRADER_CARD_DISPLAY).addTag(LCTags.Items.TRADER_FREEZER);
        this.cTag(LCTags.Items.TRADER_DISPLAY_CASE).add(ModBlocks.DISPLAY_CASE);
        this.cTag(LCTags.Items.TRADER_VENDING_MACHINE).add(ModBlocks.VENDING_MACHINE);
        this.cTag(LCTags.Items.TRADER_LARGE_VENDING_MACHINE).add(ModBlocks.VENDING_MACHINE_LARGE);
        this.cTag(LCTags.Items.TRADER_SHELF).add(ModBlocks.SHELF);
        this.cTag(LCTags.Items.TRADER_SHELF_2x2).add(ModBlocks.SHELF_2x2);
        this.cTag(LCTags.Items.TRADER_CARD_DISPLAY).add(ModBlocks.CARD_DISPLAY);
        this.cTag(LCTags.Items.TRADER_FREEZER).add(ModBlocks.FREEZER);
        this.cTag(LCTags.Items.TRADER_SPECIALTY).addTag(LCTags.Items.TRADER_SPECIALTY_ARMOR_DISPLAY).addTag(LCTags.Items.TRADER_SPECIALTY_PAYGATE).addTag(LCTags.Items.TRADER_SPECIALTY_TICKET_KIOSK).addTag(LCTags.Items.TRADER_SPECIALTY_BOOKSHELF).addTag(LCTags.Items.TRADER_SPECIALTY_SLOT_MACHINE).addTag(LCTags.Items.TRADER_SPECIALTY_GACHA_MACHINE);
        this.cTag(LCTags.Items.TRADER_SPECIALTY_ARMOR_DISPLAY).add(ModBlocks.ARMOR_DISPLAY);
        this.cTag(LCTags.Items.TRADER_SPECIALTY_PAYGATE).add(ModBlocks.PAYGATE);
        this.cTag(LCTags.Items.TRADER_SPECIALTY_TICKET_KIOSK).add(ModBlocks.TICKET_KIOSK);
        this.cTag(LCTags.Items.TRADER_SPECIALTY_BOOKSHELF).add(ModBlocks.BOOKSHELF_TRADER);
        this.cTag(LCTags.Items.TRADER_SPECIALTY_SLOT_MACHINE).add(ModBlocks.SLOT_MACHINE);
        this.cTag(LCTags.Items.TRADER_SPECIALTY_GACHA_MACHINE).add(ModBlocks.GACHA_MACHINE);
        this.cTag(LCTags.Items.TRADER_NETWORK).addTag(LCTags.Items.TRADER_NETWORK_ITEM);
        this.cTag(LCTags.Items.TRADER_NETWORK_ITEM).add(ModBlocks.ITEM_NETWORK_TRADER_1).add(ModBlocks.ITEM_NETWORK_TRADER_2).add(ModBlocks.ITEM_NETWORK_TRADER_3).add(ModBlocks.ITEM_NETWORK_TRADER_4);
        this.cTag(LCTags.Items.NETWORK_TERMINAL).add(ModBlocks.TERMINAL).add(ModItems.PORTABLE_TERMINAL).add(ModBlocks.GEM_TERMINAL).add(ModItems.PORTABLE_GEM_TERMINAL);
        this.cTag(LCTags.Items.ATM).add(ModBlocks.ATM).add(ModItems.PORTABLE_ATM);
        this.cTag(LCTags.Items.AUCTION_STAND).add(ModBlocks.AUCTION_STAND);
        this.cTag(LCTags.Items.TRADER_INTERFACE).add(ModBlocks.ITEM_TRADER_INTERFACE);
        this.cTag(LCTags.Items.COIN_JAR_NORMAL).add(ModBlocks.PIGGY_BANK).add(ModBlocks.COINJAR_BLUE);
        this.cTag(LCTags.Items.COIN_JAR_ALL).addTag(LCTags.Items.COIN_JAR_NORMAL).add(ModBlocks.SUS_JAR);
        this.cTag(LCTags.Items.TRADABLE_BOOK).add((ItemLike)Items.BOOK).add((ItemLike)Items.ENCHANTED_BOOK).add((ItemLike)Items.WRITABLE_BOOK).add((ItemLike)Items.WRITTEN_BOOK);
        this.cTag(LCTags.Items.TICKETS).addTag(LCTags.Items.TICKETS_TICKET).addTag(LCTags.Items.TICKETS_PASS).addTag(LCTags.Items.TICKETS_MASTER);
        this.cTag(LCTags.Items.TICKETS_TICKET).add(ModItems.TICKET).add(ModItems.GOLDEN_TICKET);
        this.cTag(LCTags.Items.TICKETS_PASS).add(ModItems.TICKET_PASS).add(ModItems.GOLDEN_TICKET_PASS);
        this.cTag(LCTags.Items.TICKETS_MASTER).add(ModItems.TICKET_MASTER).add(ModItems.GOLDEN_TICKET_MASTER);
        this.cTag(LCTags.Items.COUPONS).add(ModItems.COUPON);
        this.cTag(LCTags.Items.TICKET_MATERIAL).addTag(LCTags.Items.TICKET_MATERIAL_PAPER).addTag(LCTags.Items.TICKET_MATERIAL_GOLD);
        this.cTag(LCTags.Items.TICKET_MATERIAL_PAPER).add((ItemLike)Items.PAPER).add(ModItems.TICKET_STUB).add(ModItems.TICKET).add(ModItems.TICKET_PASS).add(ModItems.TICKET_MASTER).add(ModItems.COUPON);
        this.cTag(LCTags.Items.TICKET_MATERIAL_GOLD).addTag((TagKey<Item>)Tags.Items.INGOTS_GOLD).add(ModItems.GOLDEN_TICKET_STUB).add(ModItems.GOLDEN_TICKET).add(ModItems.GOLDEN_TICKET_PASS).add(ModItems.GOLDEN_TICKET_MASTER);
        this.cTag(LCTags.Items.SETTINGS_WRITABLE).add((ItemLike)Items.PAPER).add((ItemLike)Items.BOOK).add((ItemLike)Items.WRITABLE_BOOK).add((ItemLike)Items.WRITTEN_BOOK);
        this.cTag(LCTags.Items.SETTINGS_READABLE).add((ItemLike)Items.PAPER).add((ItemLike)Items.WRITTEN_BOOK);
        this.cTag(LCTags.Items.SETTINGS_READ_OR_WRITABLE).addTag(LCTags.Items.SETTINGS_WRITABLE).addTag(LCTags.Items.SETTINGS_READABLE);
        this.cTag(LCTags.Items.SETTINGS_REPLACE_WITH_WRITTEN_BOOK).add((ItemLike)Items.WRITABLE_BOOK).add((ItemLike)Items.BOOK);
        this.cTag(LCTags.Items.VARIANT_WANDS).add(ModItems.VARIANT_WAND);
        this.cTag((TagKey<Item>)ItemTags.BEACON_PAYMENT_ITEMS).add(ModItems.COIN_IRON).add(ModItems.COIN_GOLD).add(ModItems.COIN_EMERALD).add(ModItems.COIN_DIAMOND).add(ModItems.COIN_NETHERITE);
        this.cTag((TagKey<Item>)ItemTags.PIGLIN_LOVED).add(ModItems.COIN_GOLD).add(ModBlocks.COINPILE_GOLD).add(ModBlocks.COINBLOCK_GOLD);
        this.cTag((TagKey<Item>)ItemTags.DYEABLE).add(ModBlocks.SUS_JAR).add(ModItems.ATM_CARD).add(ModItems.WALLET_LEATHER);
        this.cTag(VersionUtil.modResource("curios", "wallet")).addTag(LCTags.Items.WALLET);
        this.cTag(VersionUtil.modResource("curios", "charm")).add(ModItems.PORTABLE_TERMINAL).add(ModItems.PORTABLE_GEM_TERMINAL).add(ModItems.PORTABLE_ATM);
        if (ModList.get().isLoaded("create")) {
            this.cTag(LCTags.Items.SETTINGS_WRITABLE).addOptional((Supplier<? extends ItemLike>)AllBlocks.CLIPBOARD);
            this.cTag(LCTags.Items.SETTINGS_READABLE).addOptional((Supplier<? extends ItemLike>)AllBlocks.CLIPBOARD);
        }
    }

    private CustomTagAppender cTag(TagKey<Item> tag) {
        return new CustomTagAppender((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)this.tag(tag));
    }

    private CustomTagAppender cTag(ResourceLocation tag) {
        return new CustomTagAppender((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)this.tag(ItemTags.create((ResourceLocation)tag)));
    }

    private record CustomTagAppender(IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> appender) {
        public CustomTagAppender add(ItemLike item) {
            this.appender.add((Object)item.asItem());
            return this;
        }

        public CustomTagAppender add(Supplier<? extends ItemLike> item) {
            this.add(item.get());
            return this;
        }

        public CustomTagAppender addOptional(Supplier<? extends ItemLike> item) {
            this.appender.addOptional(BuiltInRegistries.ITEM.getKey((Object)item.get().asItem()));
            return this;
        }

        public CustomTagAppender add(RegistryObjectBundle<? extends ItemLike, ?> bundle) {
            bundle.forEach((key, item) -> {
                if (key instanceof IOptionalKey) {
                    IOptionalKey ok = (IOptionalKey)key;
                    if (ok.isModded()) {
                        this.addOptional((Supplier<? extends ItemLike>)item);
                    } else {
                        this.add((Supplier<? extends ItemLike>)item);
                    }
                } else {
                    this.add((Supplier<? extends ItemLike>)item);
                }
            });
            return this;
        }

        public <T> CustomTagAppender add(RegistryObjectBiBundle<? extends ItemLike, T, ?> bundle, @Nonnull T key) {
            bundle.forEach((key1, key2, item) -> {
                if (key1 == key) {
                    if (key1 instanceof IOptionalKey) {
                        IOptionalKey ok1 = (IOptionalKey)key1;
                        if (ok1.isModded()) {
                            this.addOptional((Supplier<? extends ItemLike>)item);
                        } else if (key2 instanceof IOptionalKey) {
                            IOptionalKey ok2 = (IOptionalKey)key2;
                            if (ok2.isModded()) {
                                this.addOptional((Supplier<? extends ItemLike>)item);
                            } else {
                                this.add((Supplier<? extends ItemLike>)item);
                            }
                        }
                    } else if (key2 instanceof IOptionalKey) {
                        IOptionalKey ok2 = (IOptionalKey)key2;
                        if (ok2.isModded()) {
                            this.addOptional((Supplier<? extends ItemLike>)item);
                        } else {
                            this.add((Supplier<? extends ItemLike>)item);
                        }
                    } else {
                        this.add((Supplier<? extends ItemLike>)item);
                    }
                }
            });
            return this;
        }

        public CustomTagAppender add(RegistryObjectBiBundle<? extends ItemLike, ?, ?> bundle) {
            bundle.forEach((key1, key2, item) -> {
                if (key1 instanceof IOptionalKey) {
                    IOptionalKey ok1 = (IOptionalKey)key1;
                    if (ok1.isModded()) {
                        this.addOptional((Supplier<? extends ItemLike>)item);
                    } else if (key2 instanceof IOptionalKey) {
                        IOptionalKey ok2 = (IOptionalKey)key2;
                        if (ok2.isModded()) {
                            this.addOptional((Supplier<? extends ItemLike>)item);
                        } else {
                            this.add((Supplier<? extends ItemLike>)item);
                        }
                    } else {
                        this.add((Supplier<? extends ItemLike>)item);
                    }
                } else if (key2 instanceof IOptionalKey) {
                    IOptionalKey ok2 = (IOptionalKey)key2;
                    if (ok2.isModded()) {
                        this.addOptional((Supplier<? extends ItemLike>)item);
                    } else {
                        this.add((Supplier<? extends ItemLike>)item);
                    }
                } else {
                    this.add((Supplier<? extends ItemLike>)item);
                }
            });
            return this;
        }

        public CustomTagAppender addTag(TagKey<Item> tag) {
            this.appender.addTag(tag);
            return this;
        }

        public CustomTagAppender addTags(List<TagKey<Item>> tags) {
            for (TagKey<Item> tag : tags) {
                this.addTag(tag);
            }
            return this;
        }
    }
}

