/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.PeripheralCapability;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.api.events.TraderEvent;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.attachments.builtin.ExternalAuthorizationAttachment;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.CapabilityInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.CashRegisterBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.GachaMachineBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.PaygateBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.SlotMachineTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.traders.InputTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.gacha.GachaTrader;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.TraderPeripheralSource;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.CashRegisterPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.TerminalPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.atm.ATMPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.InputTraderPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.TraderPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.auction.AuctionHousePeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.gacha_machine.GachaMachinePeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.item.ItemTraderPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.paygate.PaygatePeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.slot_machine.SlotMachinePeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.pocket_upgrades.LCPocketUpgrades;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;

public class LCComputerHelper {
    public static List<TraderPeripheralSource> peripheralSources = new ArrayList<TraderPeripheralSource>();

    public static void setup(IEventBus modBus) {
        LCPocketUpgrades.init(modBus);
        modBus.addListener(LCComputerHelper::registerCapabilities);
        NeoForge.EVENT_BUS.addListener(LCComputerHelper::addTraderAttachments);
        LCComputerHelper.registerTraderPeripheralSource(TraderPeripheralSource.dataOnly(trader -> {
            if (trader instanceof AuctionHouseTrader) {
                return AuctionHousePeripheral.INSTANCE;
            }
            return null;
        }));
        LCComputerHelper.registerTraderPeripheralSource(TraderPeripheralSource.simple(be -> {
            if (be instanceof ItemTraderBlockEntity) {
                ItemTraderBlockEntity itbe = (ItemTraderBlockEntity)be;
                return new ItemTraderPeripheral(itbe);
            }
            return null;
        }, trader -> {
            if (trader instanceof ItemTraderData) {
                ItemTraderData itd = (ItemTraderData)trader;
                return new ItemTraderPeripheral(itd);
            }
            return null;
        }));
        LCComputerHelper.registerTraderPeripheralSource(TraderPeripheralSource.blockOnly(be -> {
            if (be instanceof PaygateBlockEntity) {
                PaygateBlockEntity paygate = (PaygateBlockEntity)be;
                return new PaygatePeripheral(paygate);
            }
            return null;
        }));
        LCComputerHelper.registerTraderPeripheralSource(TraderPeripheralSource.simple(be -> {
            if (be instanceof GachaMachineBlockEntity) {
                GachaMachineBlockEntity gacha = (GachaMachineBlockEntity)be;
                return new GachaMachinePeripheral(gacha);
            }
            return null;
        }, trader -> {
            if (trader instanceof GachaTrader) {
                GachaTrader gacha = (GachaTrader)trader;
                return new GachaMachinePeripheral(gacha);
            }
            return null;
        }));
        LCComputerHelper.registerTraderPeripheralSource(TraderPeripheralSource.simple(be -> {
            if (be instanceof SlotMachineTraderBlockEntity) {
                SlotMachineTraderBlockEntity slotMachine = (SlotMachineTraderBlockEntity)be;
                return new SlotMachinePeripheral(slotMachine);
            }
            return null;
        }, trader -> {
            if (trader instanceof SlotMachineTraderData) {
                SlotMachineTraderData slotMachine = (SlotMachineTraderData)trader;
                return new SlotMachinePeripheral(slotMachine);
            }
            return null;
        }));
    }

    public static void registerTraderPeripheralSource(TraderPeripheralSource source) {
        if (!peripheralSources.contains(source)) {
            peripheralSources.add(source);
        }
    }

    public static IPeripheral getPeripheral(TraderBlockEntity<?> be) {
        for (TraderPeripheralSource source : peripheralSources) {
            LCPeripheral result = source.tryCreate(be);
            if (result == null) continue;
            return result;
        }
        if (be.getTraderData() instanceof InputTraderData) {
            return InputTraderPeripheral.createSimpleInput(be);
        }
        return TraderPeripheral.createSimple(be);
    }

    public static LCPeripheral getPeripheral(TraderData trader) {
        for (TraderPeripheralSource source : peripheralSources) {
            LCPeripheral result = source.tryCreate(trader);
            if (result == null) continue;
            return result;
        }
        if (trader instanceof InputTraderData) {
            InputTraderData it = (InputTraderData)trader;
            return InputTraderPeripheral.createSimpleInput(it);
        }
        return TraderPeripheral.createSimple(trader);
    }

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        CapabilityInterfaceBlockEntity.easyRegisterCapProvider(event, PeripheralCapability.get());
        LCComputerHelper.registerTraderCapability(event, ModBlockEntities.ITEM_TRADER);
        LCComputerHelper.registerTraderCapability(event, ModBlockEntities.ARMOR_TRADER);
        LCComputerHelper.registerTraderCapability(event, ModBlockEntities.FREEZER_TRADER);
        LCComputerHelper.registerTraderCapability(event, ModBlockEntities.TICKET_TRADER);
        LCComputerHelper.registerTraderCapability(event, ModBlockEntities.BOOK_TRADER);
        LCComputerHelper.registerTraderCapability(event, ModBlockEntities.SLOT_MACHINE_TRADER);
        LCComputerHelper.registerTraderCapability(event, ModBlockEntities.GACHA_MACHINE);
        LCComputerHelper.registerTraderCapability(event, ModBlockEntities.PAYGATE);
        event.registerBlock(PeripheralCapability.get(), (level, pos, state, be, side) -> TerminalPeripheral.INSTANCE, new Block[]{ModBlocks.TERMINAL.get(), ModBlocks.GEM_TERMINAL.get()});
        event.registerBlockEntity(PeripheralCapability.get(), ModBlockEntities.AUCTION_STAND.get(), (be, side) -> {
            if (((Boolean)LCConfig.SERVER.auctionHouseEnabled.get()).booleanValue()) {
                return AuctionHousePeripheral.INSTANCE;
            }
            return null;
        });
        event.registerBlockEntity(PeripheralCapability.get(), ModBlockEntities.CASH_REGISTER.get(), (be, side) -> new CashRegisterPeripheral((CashRegisterBlockEntity)be));
        event.registerBlock(PeripheralCapability.get(), (level, pos, state, be, side) -> ATMPeripheral.INSTANCE, new Block[]{ModBlocks.ATM.get()});
    }

    private static void addTraderAttachments(TraderEvent.RegisterAttachmentEvent event) {
        if (event.getTrader() instanceof AuctionHouseTrader) {
            return;
        }
        event.addAttachment(ExternalAuthorizationAttachment.TYPE);
    }

    public static <T extends TraderBlockEntity<?>> void registerTraderCapability(RegisterCapabilitiesEvent event, Supplier<BlockEntityType<T>> type) {
        LCComputerHelper.registerTraderCapability(event, type.get());
    }

    public static void registerTraderCapability(RegisterCapabilitiesEvent event, BlockEntityType<? extends TraderBlockEntity<?>> type) {
        event.registerBlockEntity(PeripheralCapability.get(), type, (be, side) -> {
            if (be instanceof TraderBlockEntity) {
                TraderBlockEntity tbe = be;
                return LCComputerHelper.getPeripheral(tbe);
            }
            return null;
        });
    }
}

