/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.data;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaValues;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValueParser;
import io.github.lightman314.lightmanscurrency.common.util.LookupHelper;
import io.github.lightman314.lightmanscurrency.integration.computercraft.data.LCLuaTable;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class LCArgumentHelper {
    public static MoneyValue parseMoneyValue(IArguments args, int index, boolean allowEmpty) throws LuaException {
        if (Objects.equals(args.getType(index), "string")) {
            try {
                return MoneyValueParser.parse(new StringReader(args.getString(index)), allowEmpty);
            }
            catch (CommandSyntaxException ignored) {
                throw LuaValues.badArgumentOf((IArguments)args, (int)index, (String)"money_value");
            }
        }
        CompoundTag tag = LCLuaTable.toTag(args.getTable(index));
        MoneyValue result = MoneyValue.load(tag);
        if (result == null) {
            throw LuaValues.badArgumentOf((IArguments)args, (int)index, (String)"money_value");
        }
        return result;
    }

    public static <T extends Enum<T>> T parseEnum(IArguments args, int index, Class<T> clazz) throws LuaException {
        return (T)LuaValues.checkEnum((int)index, clazz, (String)args.getString(index));
    }

    public static ResourceLocation parseResourceLocation(IArguments args, int index) throws LuaException {
        try {
            return VersionUtil.parseResource(args.getString(index));
        }
        catch (ResourceLocationException e) {
            throw LuaValues.badArgumentOf((IArguments)args, (int)index, (String)"id");
        }
    }

    public static ItemStack parseItem(IArguments args, int index) throws LuaException {
        if (Objects.equals(args.getType(index), "string")) {
            ResourceLocation itemID = LCArgumentHelper.parseResourceLocation(args, index);
            if (BuiltInRegistries.ITEM.containsKey(itemID)) {
                return new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(itemID));
            }
            throw LuaValues.badArgumentOf((IArguments)args, (int)index, (String)"item");
        }
        CompoundTag tag = LCLuaTable.toTag(args.getTable(index));
        Optional item = ItemStack.parse((HolderLookup.Provider)LookupHelper.getRegistryAccess(), (Tag)tag);
        if (item.isEmpty()) {
            throw LuaValues.badArgumentOf((IArguments)args, (int)index, (String)"item");
        }
        return (ItemStack)item.get();
    }

    public static FluidStack parseFluid(IArguments args, int index) throws LuaException {
        if (Objects.equals(args.getType(index), "string")) {
            ResourceLocation fluidID = LCArgumentHelper.parseResourceLocation(args, index);
            if (BuiltInRegistries.FLUID.containsKey(fluidID)) {
                return new FluidStack((Fluid)BuiltInRegistries.FLUID.get(fluidID), 1000);
            }
            throw LuaValues.badArgumentOf((IArguments)args, (int)index, (String)"fluid");
        }
        CompoundTag tag = LCLuaTable.toTag(args.getTable(index));
        Optional fluid = FluidStack.parse((HolderLookup.Provider)LookupHelper.getRegistryAccess(), (Tag)tag);
        if (fluid.isEmpty()) {
            throw LuaValues.badArgumentOf((IArguments)args, (int)index, (String)"fluid");
        }
        return (FluidStack)fluid.get();
    }
}

