/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.data;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaTable;
import dan200.computercraft.api.lua.LuaValues;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValueParser;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyViewer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LCLuaTable
implements LuaTable<Object, Object> {
    private final Map<Object, Object> map;

    public LCLuaTable() {
        this.map = new HashMap<Object, Object>();
    }

    public LCLuaTable(Map<?, ?> map) {
        this.map = new HashMap(map);
    }

    public LCLuaTable copy() {
        return new LCLuaTable(this.map);
    }

    public static LCLuaTable fromTag(CompoundTag compound) {
        LCLuaTable table = new LCLuaTable();
        for (String key : compound.getAllKeys()) {
            Tag tag = compound.get(key);
            table.put(key, LCLuaTable.parseTag(compound.get(key)));
        }
        return table;
    }

    public static CompoundTag toTag(Map<?, ?> table) {
        CompoundTag tag = new CompoundTag();
        for (Object key : table.keySet()) {
            String k;
            Tag t;
            if (!(key instanceof String) || (t = LCLuaTable.parseObject(table.get(k = (String)key))) == null) continue;
            tag.put(k, t);
        }
        return tag;
    }

    public static Object parseTag(Tag tag) {
        if (tag instanceof ByteArrayTag) {
            ByteArrayTag t = (ByteArrayTag)tag;
            return LCLuaTable.fromArray(t.getAsByteArray());
        }
        if (tag instanceof ByteTag) {
            ByteTag t = (ByteTag)tag;
            return t.getAsByte();
        }
        if (tag instanceof CompoundTag) {
            CompoundTag t = (CompoundTag)tag;
            return LCLuaTable.fromTag(t);
        }
        if (tag instanceof DoubleTag) {
            DoubleTag t = (DoubleTag)tag;
            return t.getAsDouble();
        }
        if (tag instanceof FloatTag) {
            FloatTag t = (FloatTag)tag;
            return Float.valueOf(t.getAsFloat());
        }
        if (tag instanceof IntArrayTag) {
            IntArrayTag t = (IntArrayTag)tag;
            return LCLuaTable.fromArray(t.getAsIntArray(), true);
        }
        if (tag instanceof IntTag) {
            IntTag t = (IntTag)tag;
            return t.getAsInt();
        }
        if (tag instanceof ListTag) {
            ListTag t = (ListTag)tag;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Tag value : t) {
                result.add(LCLuaTable.parseTag(value));
            }
            return LCLuaTable.fromList(result);
        }
        if (tag instanceof LongArrayTag) {
            LongArrayTag t = (LongArrayTag)tag;
            return LCLuaTable.fromArray(t.getAsLongArray());
        }
        if (tag instanceof LongTag) {
            LongTag t = (LongTag)tag;
            return t.getAsLong();
        }
        if (tag instanceof ShortTag) {
            ShortTag t = (ShortTag)tag;
            return t.getAsShort();
        }
        if (tag instanceof StringTag) {
            StringTag t = (StringTag)tag;
            return t.getAsString();
        }
        LightmansCurrency.LogDebug("Unknown Tag type received " + tag.getClass().getName());
        return null;
    }

    public static LCLuaTable fromArray(byte[] array) {
        Object[] newArray = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return LCLuaTable.fromArray(newArray);
    }

    public static Object fromArray(int[] array, boolean uuidTest) {
        if (uuidTest && array.length == 4) {
            return UUIDUtil.uuidFromIntArray((int[])array).toString();
        }
        Object[] newArray = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return LCLuaTable.fromArray(newArray);
    }

    public static LCLuaTable fromArray(long[] array) {
        Object[] newArray = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return LCLuaTable.fromArray(newArray);
    }

    public static LCLuaTable fromArray(Object[] array) {
        LCLuaTable table = new LCLuaTable();
        for (int i = 0; i < array.length; ++i) {
            table.put(i + 1, array[i]);
        }
        return table;
    }

    public static LCLuaTable fromList(List<?> list) {
        LCLuaTable table = new LCLuaTable();
        for (int i = 0; i < list.size(); ++i) {
            table.put(i + 1, list.get(i));
        }
        return table;
    }

    @Nullable
    public static Tag parseObject(Object object) {
        Object s;
        ListTag result;
        if (object instanceof byte[]) {
            byte[] ba = (byte[])object;
            return new ByteArrayTag(ba);
        }
        if (object instanceof Byte) {
            Byte b = (Byte)object;
            return ByteTag.valueOf((byte)b);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Set keys = map.keySet();
            if (keys.isEmpty()) {
                return new CompoundTag();
            }
            if (LCLuaTable.isStringKey(keys)) {
                return LCLuaTable.toTag(map);
            }
            if (LCLuaTable.isIntKey(keys)) {
                return LCLuaTable.toListTag(map);
            }
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            return DoubleTag.valueOf((double)d);
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            return FloatTag.valueOf((float)f.floatValue());
        }
        if (object instanceof int[]) {
            int[] ia = (int[])object;
            return new IntArrayTag(ia);
        }
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            return IntTag.valueOf((int)i);
        }
        if (object instanceof List) {
            List list = (List)object;
            result = new ListTag();
            for (Object value : list) {
                result.add((Object)LCLuaTable.parseObject(value));
            }
            return result;
        }
        if (object instanceof long[]) {
            long[] la = (long[])object;
            return new LongArrayTag(la);
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return LongTag.valueOf((long)l);
        }
        if (object instanceof Short) {
            s = (Short)object;
            return ShortTag.valueOf((short)((Short)s));
        }
        if (object instanceof String) {
            s = (String)object;
            try {
                UUID uuid = UUID.fromString((String)s);
                return new IntArrayTag(UUIDUtil.uuidToIntArray((UUID)uuid));
            }
            catch (IllegalArgumentException uuid) {
                return StringTag.valueOf((String)s);
            }
        }
        if (object instanceof Object[]) {
            Object[] oa = (Object[])object;
            result = new ListTag();
            for (Object value : oa) {
                result.add((Object)LCLuaTable.parseObject(value));
            }
            return result;
        }
        return null;
    }

    private static Tag toListTag(Map<?, ?> map) {
        Object[] array2;
        ListTag result = new ListTag();
        ArrayList<Tag> backingList = new ArrayList<Tag>();
        byte type = 0;
        for (Object key : map.keySet()) {
            Number n;
            int index;
            if (!(key instanceof Number) || (index = (n = (Number)key).intValue() - 1) < 0) continue;
            while (backingList.size() < index) {
                backingList.add(null);
            }
            Tag newEntry = LCLuaTable.parseObject(map.get(key));
            if (type == 0) {
                type = newEntry.getId();
            } else if (type != newEntry.getId()) {
                return result;
            }
            backingList.set(index, newEntry);
        }
        if (backingList.stream().anyMatch(Objects::isNull)) {
            return result;
        }
        if (type == 1) {
            try {
                array2 = new byte[backingList.size()];
                for (int i = 0; i < backingList.size(); ++i) {
                    array2[i] = ((NumericTag)backingList.get(i)).getAsByte();
                }
                return new ByteArrayTag(array2);
            }
            catch (ClassCastException array2) {
                // empty catch block
            }
        }
        if (type == 3) {
            try {
                array2 = new int[backingList.size()];
                for (int i = 0; i < backingList.size(); ++i) {
                    array2[i] = ((NumericTag)backingList.get(i)).getAsInt();
                }
                return new IntArrayTag((int[])array2);
            }
            catch (ClassCastException array3) {
                // empty catch block
            }
        }
        if (type == 4) {
            try {
                array2 = new long[backingList.size()];
                for (int i = 0; i < backingList.size(); ++i) {
                    array2[i] = (byte)((NumericTag)backingList.get(i)).getAsLong();
                }
                return new LongArrayTag((long[])array2);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        result.addAll(backingList);
        return result;
    }

    private static boolean isStringKey(Set<?> set) {
        return set.stream().allMatch(key -> key instanceof String);
    }

    private static boolean isIntKey(Set<?> set) {
        return set.stream().allMatch(key -> key instanceof Number);
    }

    public static LCLuaTable fromMoney(MoneyValue value) {
        LCLuaTable table = new LCLuaTable();
        table.put("numeric", value.getCoreValue());
        table.put("text", value.getText("Empty").getString());
        table.put("data", LCLuaTable.fromTag(value.save()));
        table.put("arg", MoneyValueParser.writeParsable(value));
        return table;
    }

    public static LCLuaTable fromMoney(IMoneyViewer values) {
        LCLuaTable table = new LCLuaTable();
        for (MoneyValue value : values.getStoredMoney().allValues()) {
            table.put(value.getUniqueName(), LCLuaTable.fromMoney(value));
        }
        return table;
    }

    public static LCLuaTable fromPlayer(Player player) {
        return LCLuaTable.fromPlayer(PlayerReference.of(player));
    }

    public static LCLuaTable fromPlayer(PlayerReference player) {
        LCLuaTable table = new LCLuaTable();
        table.put("Name", player.getName(false));
        table.put("ID", player.id);
        return table;
    }

    public boolean getBoolean(String key) throws LuaException {
        Object value = this.get(key);
        if (!(value instanceof Boolean)) {
            throw LuaValues.badField((String)key, (String)"boolean", (String)LuaValues.getType((Object)value));
        }
        return (Boolean)value;
    }

    public String getString(String key) throws LuaException {
        Object value = this.get(key);
        if (!(value instanceof String)) {
            throw LuaValues.badField((String)key, (String)"string", (String)LuaValues.getType((Object)value));
        }
        return (String)value;
    }

    public LCLuaTable getTable(String key) throws LuaException {
        Object value = this.get(key);
        if (!(value instanceof Map)) {
            throw LuaValues.badField((String)key, (String)"table", (String)LuaValues.getType((Object)value));
        }
        return new LCLuaTable((Map)value);
    }

    public Optional<Boolean> getOptBoolean(String key) throws LuaException {
        Object value = this.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof Boolean)) {
            throw LuaValues.badField((String)key, (String)"boolean", (String)LuaValues.getType((Object)value));
        }
        return Optional.of((Boolean)value);
    }

    public Set<String> stringKeySet() throws LuaException {
        HashSet<String> stringSet = new HashSet<String>();
        for (Object key : this.keySet()) {
            if (!(key instanceof String)) {
                throw new LuaException("key " + String.valueOf(key) + " is not string (got " + LuaValues.getType((Object)key) + ")");
            }
            stringSet.add((String)key);
        }
        return Collections.unmodifiableSet(stringSet);
    }

    public Collection<LCLuaTable> tableValues() throws LuaException {
        ArrayList<LCLuaTable> tables = new ArrayList<LCLuaTable>();
        for (int i = 1; i <= this.size(); ++i) {
            Object value = this.get(i);
            if (!(value instanceof Map)) {
                throw new LuaException("value " + String.valueOf(value) + " is not table (got " + LuaValues.getType((Object)value) + ")");
            }
            tables.add(new LCLuaTable((Map)value));
        }
        return Collections.unmodifiableList(tables);
    }

    public Map<Object, Object> getMap() {
        return this.map;
    }

    @Nullable
    public Object put(Object key, Object value) {
        return this.map.put(key, value);
    }

    public void putBoolean(String key, boolean value) {
        this.map.put(key, value);
    }

    public void putDouble(String key, double value) {
        this.map.put(key, value);
    }

    public void putString(String key, String value) {
        this.map.put(key, value);
    }

    public void putTable(String key, LCLuaTable value) {
        this.map.put(key, value);
    }

    public void putTable(int i, LCLuaTable value) {
        this.map.put(i, value);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object o) {
        return this.map.containsKey(o);
    }

    public boolean containsValue(Object o) {
        return this.map.containsValue(o);
    }

    public Object get(Object o) {
        return this.map.get(o);
    }

    @NotNull
    public Set<Object> keySet() {
        return this.map.keySet();
    }

    @NotNull
    public Collection<Object> values() {
        return this.map.values();
    }

    @NotNull
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.map.entrySet();
    }
}

