/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettingsState;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeSettingNotification;
import io.github.lightman314.lightmanscurrency.common.traders.InputTraderData;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCPeripheralMethod;
import io.github.lightman314.lightmanscurrency.integration.computercraft.data.LCArgumentHelper;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.TradeWrapper;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.TraderPeripheral;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;

public abstract class InputTraderPeripheral<BE extends TraderBlockEntity<T>, T extends InputTraderData>
extends TraderPeripheral<BE, T> {
    public InputTraderPeripheral(BE be) {
        super(be);
    }

    public InputTraderPeripheral(T trader) {
        super(trader);
    }

    public static InputTraderPeripheral<TraderBlockEntity<InputTraderData>, InputTraderData> createSimpleInput(TraderBlockEntity<InputTraderData> blockEntity) {
        return new Simple(blockEntity);
    }

    public static InputTraderPeripheral<TraderBlockEntity<InputTraderData>, InputTraderData> createSimpleInput(InputTraderData trader) {
        return new Simple(trader);
    }

    @Override
    public Set<String> getAdditionalTypes() {
        HashSet<String> set = new HashSet<String>(super.getAdditionalTypes());
        set.add("lc_trader_input");
        return set;
    }

    public boolean allowsInputs() throws LuaException {
        return ((InputTraderData)this.getTrader()).allowInputs();
    }

    public boolean allowInputSide(IArguments args) throws LuaException {
        return ((InputTraderData)this.getTrader()).allowInputSide(LCArgumentHelper.parseEnum(args, 0, Direction.class));
    }

    public boolean setInputSide(IComputerAccess computer, IArguments args) throws LuaException {
        InputTraderData trader;
        Direction side = LCArgumentHelper.parseEnum(args, 0, Direction.class);
        boolean newInputState = args.getBoolean(1);
        if (this.hasPermissions(computer, "changeExternalInputs") && (trader = (InputTraderData)this.getTrader()).allowInputSide(side) != newInputState && trader.allowInputs() && !trader.ignoreSides.contains((Object)side)) {
            DirectionalSettingsState oldState = trader.getSidedState(side);
            DirectionalSettingsState newState = oldState.allowsOutputs() ? (newInputState ? DirectionalSettingsState.INPUT_AND_OUTPUT : DirectionalSettingsState.OUTPUT) : (newInputState ? DirectionalSettingsState.INPUT : DirectionalSettingsState.NONE);
            trader.setDirectionalState(null, side, newState);
            trader.pushLocalNotification(ChangeSettingNotification.simple(this.getFakePlayer(computer), (Component)EasyText.empty().append((Component)LCText.DATA_ENTRY_INPUT_OUTPUT_SIDES.get(new Object[0])).append((Component)InputTraderData.getFacingName(side)), (Component)newState.getText()));
            return true;
        }
        return false;
    }

    public String[] getInputSides() throws LuaException {
        InputTraderData trader = (InputTraderData)this.getTrader();
        ArrayList<String> sides = new ArrayList<String>();
        for (Direction side : Direction.values()) {
            if (!trader.allowInputSide(side)) continue;
            sides.add(side.toString());
        }
        return (String[])sides.toArray(String[]::new);
    }

    public boolean allowsOutputs() throws LuaException {
        return ((InputTraderData)this.getTrader()).allowOutputs();
    }

    public boolean allowOutputSide(IArguments args) throws LuaException {
        return ((InputTraderData)this.getTrader()).allowOutputSide(LCArgumentHelper.parseEnum(args, 0, Direction.class));
    }

    public boolean setOutputSide(IComputerAccess computer, IArguments args) throws LuaException {
        InputTraderData trader;
        Direction side = LCArgumentHelper.parseEnum(args, 0, Direction.class);
        boolean newOutputState = args.getBoolean(1);
        if (this.hasPermissions(computer, "changeExternalInputs") && (trader = (InputTraderData)this.getTrader()).allowOutputSide(side) != newOutputState && trader.allowOutputs() && !trader.ignoreSides.contains((Object)side)) {
            DirectionalSettingsState oldState = trader.getSidedState(side);
            DirectionalSettingsState newState = oldState.allowsInputs() ? (newOutputState ? DirectionalSettingsState.INPUT_AND_OUTPUT : DirectionalSettingsState.INPUT) : (newOutputState ? DirectionalSettingsState.OUTPUT : DirectionalSettingsState.NONE);
            trader.setDirectionalState(null, side, newState);
            trader.pushLocalNotification(ChangeSettingNotification.simple(this.getFakePlayer(computer), (Component)EasyText.empty().append((Component)LCText.DATA_ENTRY_INPUT_OUTPUT_SIDES.get(new Object[0])).append((Component)InputTraderData.getFacingName(side)), (Component)newState.getText()));
            return true;
        }
        return false;
    }

    public String[] getOutputSides() throws LuaException {
        InputTraderData trader = (InputTraderData)this.getTrader();
        ArrayList<String> sides = new ArrayList<String>();
        for (Direction side : Direction.values()) {
            if (!trader.allowOutputSide(side)) continue;
            sides.add(side.toString());
        }
        return (String[])sides.toArray(String[]::new);
    }

    @Override
    protected void registerMethods(LCPeripheralMethod.Registration registration) {
        super.registerMethods(registration);
        registration.register(LCPeripheralMethod.builder("allowsInputs").simple(this::allowsInputs));
        registration.register(LCPeripheralMethod.builder("allowsInputSide").withArgs(this::allowInputSide));
        registration.register(LCPeripheralMethod.builder("setInputSide").withContext(this::setInputSide));
        registration.register(LCPeripheralMethod.builder("getInputSides").simpleArray(this::getInputSides));
        registration.register(LCPeripheralMethod.builder("allowsOutputs").simple(this::allowsOutputs));
        registration.register(LCPeripheralMethod.builder("allowsOutputSide").withArgs(this::allowOutputSide));
        registration.register(LCPeripheralMethod.builder("setOutputSide").withContext(this::setOutputSide));
        registration.register(LCPeripheralMethod.builder("getOutputSides").simpleArray(this::getOutputSides));
    }

    private static final class Simple
    extends InputTraderPeripheral<TraderBlockEntity<InputTraderData>, InputTraderData> {
        private Simple(TraderBlockEntity<InputTraderData> blockEntity) {
            super(blockEntity);
        }

        private Simple(InputTraderData trader) {
            super(trader);
        }

        @Override
        @Nullable
        protected LCPeripheral wrapTrade(TradeData trade) throws LuaException {
            int index = ((InputTraderData)this.getTrader()).indexOfTrade(trade);
            return TradeWrapper.createSimple(() -> {
                Object trader = this.safeGetTrader();
                if (trader != null) {
                    if (index < 0 || index >= ((TraderData)trader).getTradeCount()) {
                        return null;
                    }
                    return ((TraderData)trader).getTrade(index);
                }
                return null;
            }, this::safeGetTrader);
        }

        public String getType() {
            return "lc_trader_input";
        }

        @Override
        public Set<String> getAdditionalTypes() {
            HashSet<String> set = new HashSet<String>(super.getAdditionalTypes());
            set.remove("lc_trader_input");
            return set;
        }
    }
}

