/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.create.filter;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.filter.IItemTradeFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CreateItemTradeFilter
implements IItemTradeFilter {
    public static final IItemTradeFilter INSTANCE = new CreateItemTradeFilter();

    private CreateItemTradeFilter() {
    }

    @Override
    @Nullable
    public Predicate<ItemStack> getFilter(ItemStack stack) {
        if (stack.getItem() instanceof FilterItem) {
            Level level = LightmansCurrency.getProxy().safeGetDummyLevel();
            if (level == null) {
                return null;
            }
            if (stack.getItem() == AllItems.FILTER.get() || stack.getItem() == AllItems.ATTRIBUTE_FILTER.get()) {
                FilterItemStack filter = FilterItemStack.of((ItemStack)stack);
                if (filter.getClass() == FilterItemStack.class) {
                    return null;
                }
                return s -> filter.test(level, s);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public List<Component> getCustomTooltip(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof FilterItem) {
            FilterItem filter = (FilterItem)item;
            ArrayList<Component> result = new ArrayList<Component>();
            filter.appendHoverText(stack, Item.TooltipContext.EMPTY, result, (TooltipFlag)TooltipFlag.NORMAL);
            if (!result.isEmpty()) {
                result.removeFirst();
            }
            return result;
        }
        return null;
    }
}

