/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.create.pretty_settings;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllDataComponents;
import com.simibubi.create.content.equipment.clipboard.ClipboardEntry;
import com.simibubi.create.content.equipment.clipboard.ClipboardOverrides;
import io.github.lightman314.lightmanscurrency.api.settings.pretty.PrettyTextData;
import io.github.lightman314.lightmanscurrency.api.settings.pretty.PrettyTextWriter;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ClipboardPrettyWriter
extends PrettyTextWriter {
    public static PrettyTextWriter INSTANCE = new ClipboardPrettyWriter();
    public static final int LINES_PER_PAGE = 15;

    private ClipboardPrettyWriter() {
    }

    @Override
    public boolean worksOnStack(ItemStack stack) {
        return stack.getItem() == AllBlocks.CLIPBOARD.asItem();
    }

    @Override
    public ItemStack writeLinesToStack(@Nullable Player player, ItemStack stack, PrettyTextData data) {
        ArrayList<ImmutableList> pages = new ArrayList<ImmutableList>();
        ArrayList<ClipboardEntry> currentPage = new ArrayList<ClipboardEntry>();
        for (Component line : data.lines()) {
            MutableComponent copy = line.copy().withStyle(Style.EMPTY);
            currentPage.add(new ClipboardEntry(false, copy));
            if (currentPage.size() < 15) continue;
            pages.add(ImmutableList.copyOf(currentPage));
            currentPage = new ArrayList();
        }
        if (!currentPage.isEmpty()) {
            pages.add(ImmutableList.copyOf(currentPage));
        }
        stack.set(AllDataComponents.CLIPBOARD_PAGES, (Object)ImmutableList.copyOf(pages));
        stack.set(AllDataComponents.CLIPBOARD_READ_ONLY, (Object)Unit.INSTANCE);
        stack.set(AllDataComponents.CLIPBOARD_TYPE, (Object)ClipboardOverrides.ClipboardType.WRITTEN);
        stack.set(DataComponents.CUSTOM_NAME, (Object)data.machineName());
        return stack;
    }
}

