/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.curios;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.gamerule.ModGameRules;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenuBase;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import org.jetbrains.annotations.ApiStatus;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@ApiStatus.Internal
public class LCCuriosInternal {
    public static final String WALLET_SLOT = "wallet";

    @Nullable
    private static ICuriosItemHandler getCurios(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).orElse(null);
    }

    @Nullable
    private static ICurioStacksHandler getStacks(LivingEntity entity, String slot) {
        ICuriosItemHandler handler = LCCuriosInternal.getCurios(entity);
        if (handler != null) {
            return handler.getStacksHandler(slot).orElse(null);
        }
        return null;
    }

    public static boolean hasWalletSlot(LivingEntity entity) {
        try {
            ICurioStacksHandler handler = LCCuriosInternal.getStacks(entity, WALLET_SLOT);
            return handler != null && handler.getSlots() > 0;
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error with Curios Integration!", t);
            return false;
        }
    }

    public static ItemStack getCuriosWalletItem(LivingEntity entity) {
        try {
            ICurioStacksHandler handler = LCCuriosInternal.getStacks(entity, WALLET_SLOT);
            if (handler != null && handler.getSlots() > 0) {
                return handler.getStacks().getStackInSlot(0);
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error with Curios Integration!", t);
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getVisibleCuriosWalletItem(LivingEntity entity) {
        try {
            ICurioStacksHandler handler = LCCuriosInternal.getStacks(entity, WALLET_SLOT);
            if (handler != null && handler.getSlots() > 0) {
                ItemStack cosmetic = ItemStack.EMPTY;
                if (handler.getCosmeticStacks().getSlots() > 0) {
                    cosmetic = handler.getCosmeticStacks().getStackInSlot(0);
                }
                return cosmetic.isEmpty() ? handler.getStacks().getStackInSlot(0) : cosmetic;
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error with Curios Integration!", t);
        }
        return ItemStack.EMPTY;
    }

    public static void setCuriosWalletItem(LivingEntity entity, ItemStack item) {
        try {
            ICurioStacksHandler handler = LCCuriosInternal.getStacks(entity, WALLET_SLOT);
            if (handler != null && handler.getSlots() > 0) {
                handler.getStacks().setStackInSlot(0, item);
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error with Curios Integration!", t);
        }
    }

    public static boolean getCuriosWalletVisiblity(LivingEntity entity) {
        try {
            ICurioStacksHandler handler = LCCuriosInternal.getStacks(entity, WALLET_SLOT);
            if (handler != null && handler.getSlots() > 0) {
                return (Boolean)handler.getRenders().getFirst();
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error with Curios Integration!", t);
        }
        return false;
    }

    public static boolean hasItem(LivingEntity entity, Predicate<ItemStack> check) {
        try {
            ICuriosItemHandler handler = LCCuriosInternal.getCurios(entity);
            if (handler != null) {
                for (ICurioStacksHandler stacks : handler.getCurios().values()) {
                    IDynamicStackHandler sh = stacks.getStacks();
                    for (int i = 0; i < sh.getSlots(); ++i) {
                        if (!check.test(sh.getStackInSlot(i))) continue;
                        return true;
                    }
                }
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error with Curios Integration!", t);
        }
        return false;
    }

    @Nullable
    public static Item lookupItem(LivingEntity entity, Predicate<ItemStack> test) {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        LCCuriosInternal.hasItem(entity, stack -> {
            if (test.test((ItemStack)stack)) {
                result.set(stack.getItem());
                return true;
            }
            return false;
        });
        return result.get();
    }

    @Nullable
    public static ItemStack getRandomItem(LivingEntity entity, Predicate<ItemStack> check) {
        try {
            ICuriosItemHandler handler = LCCuriosInternal.getCurios(entity);
            if (handler != null) {
                ArrayList<ItemStack> options = new ArrayList<ItemStack>();
                for (ICurioStacksHandler stacks : handler.getCurios().values()) {
                    IDynamicStackHandler sh = stacks.getStacks();
                    for (int i = 0; i < sh.getSlots(); ++i) {
                        ItemStack stack = sh.getStackInSlot(i);
                        if (!check.test(stack)) continue;
                        options.add(stack);
                    }
                }
                if (!options.isEmpty()) {
                    return (ItemStack)options.get(entity.getRandom().nextInt(options.size()));
                }
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error with Curios Integration!", t);
        }
        return null;
    }

    public static void setup(IEventBus modBus) {
        modBus.addListener(LCCuriosInternal::registerCuriosItems);
    }

    private static void registerCuriosItems(FMLCommonSetupEvent event) {
        BuiltInRegistries.ITEM.forEach(item -> {
            if (item instanceof WalletItem) {
                WalletItem walletItem = (WalletItem)item;
                CuriosApi.registerCurio((Item)item, (ICurioItem)WalletCurio.INSTANCE);
            }
        });
    }

    private static class WalletCurio
    implements ICurioItem {
        private static final ICurioItem INSTANCE = new WalletCurio();

        private WalletCurio() {
        }

        public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
            return new ICurio.SoundInfo((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), 1.0f, 1.0f);
        }

        public boolean canEquipFromUse(SlotContext context, ItemStack stack) {
            return false;
        }

        public boolean canUnequip(SlotContext context, ItemStack stack) {
            LivingEntity livingEntity = context.entity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                livingEntity = player.containerMenu;
                if (livingEntity instanceof WalletMenuBase) {
                    WalletMenuBase menu = (WalletMenuBase)livingEntity;
                    return !menu.isEquippedWallet();
                }
            }
            return true;
        }

        public ICurio.DropRule getDropRule(SlotContext context, DamageSource source, boolean recentlyHit, ItemStack stack) {
            if (ModGameRules.safeGetCustomBool(context.entity().level(), ModGameRules.KEEP_WALLET, false)) {
                return ICurio.DropRule.ALWAYS_KEEP;
            }
            return ICurio.DropRule.DEFAULT;
        }
    }
}

