/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.jeiplugin.util;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class JEIScreenArea<T extends EasyMenuScreen<?>>
implements IGuiContainerHandler<T> {
    private final IIngredientManager manager;

    public static <T extends EasyMenuScreen<?>> JEIScreenArea<T> create(Class<T> clazz, IIngredientManager manager) {
        return new JEIScreenArea<T>(manager);
    }

    private JEIScreenArea(IIngredientManager manager) {
        this.manager = manager;
    }

    @Nonnull
    public List<Rect2i> getGuiExtraAreas(@Nonnull T screen) {
        ArrayList<Rect2i> list = new ArrayList<Rect2i>();
        ScreenArea screenArea = ((EasyMenuScreen)screen).getArea();
        for (GuiEventListener child : screen.children()) {
            ScreenArea area;
            if (!(child instanceof EasyWidget)) continue;
            EasyWidget widget = (EasyWidget)child;
            if (!widget.visible || !screenArea.isOutside(area = widget.getArea())) continue;
            list.add(new Rect2i(area.x, area.y, area.width, area.height));
        }
        return list;
    }

    @Nonnull
    public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(@Nonnull T screen, double mouseX, double mouseY) {
        ScreenPosition mousePos = ScreenPosition.of(mouseX, mouseY);
        Pair item = screen.getHoveredItem(mousePos);
        Optional optional = Optional.empty();
        if (item != null && !((ItemStack)item.getFirst()).isEmpty()) {
            return this.createClickable((ItemStack)item.getFirst(), (ScreenArea)item.getSecond());
        }
        Pair fluid = screen.getHoveredFluid(mousePos);
        if (fluid != null && !((FluidStack)fluid.getFirst()).isEmpty()) {
            return this.createClickable((FluidStack)fluid.getFirst(), (ScreenArea)fluid.getSecond());
        }
        return Optional.empty();
    }

    private Optional<IClickableIngredient<?>> createClickable(ItemStack item, ScreenArea area) {
        return JEIScreenArea.mapOptional(this.manager.createClickableIngredient((Object)item, JEIScreenArea.asRect(area), true));
    }

    private Optional<IClickableIngredient<?>> createClickable(FluidStack fluid, ScreenArea area) {
        return JEIScreenArea.mapOptional(this.manager.createClickableIngredient((Object)fluid, JEIScreenArea.asRect(area), true));
    }

    private static Rect2i asRect(ScreenArea area) {
        return new Rect2i(area.x, area.y, area.width, area.height);
    }

    private static <T> Optional<IClickableIngredient<?>> mapOptional(Optional<IClickableIngredient<T>> input) {
        return Optional.ofNullable(input.orElse(null));
    }
}

