/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.config;

import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SPacketReloadConfig
extends ServerToClientPacket {
    private static final CustomPacketPayload.Type<SPacketReloadConfig> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("s_config_reload"));
    public static final CustomPacket.Handler<SPacketReloadConfig> HANDLER = new H();
    private final ResourceLocation file;

    public SPacketReloadConfig(ResourceLocation file) {
        super(TYPE);
        this.file = file;
    }

    private static void encode(FriendlyByteBuf buffer, SPacketReloadConfig message) {
        buffer.writeResourceLocation(message.file);
    }

    private static SPacketReloadConfig decode(FriendlyByteBuf buffer) {
        return new SPacketReloadConfig(buffer.readResourceLocation());
    }

    private static class H
    extends CustomPacket.Handler<SPacketReloadConfig> {
        protected H() {
            super(TYPE, StreamCodec.of(SPacketReloadConfig::encode, SPacketReloadConfig::decode));
        }

        @Override
        protected void handle(@Nonnull SPacketReloadConfig message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            ConfigFile file = ConfigFile.lookupFile(message.file);
            if (file != null && file.isClientOnly()) {
                file.reload();
            }
        }
    }
}

