/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.persistentdata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.data.types.TraderDataCache;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CPacketCreatePersistentTrader
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketCreatePersistentTrader> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_persistent_make_trader"));
    public static final CustomPacket.Handler<CPacketCreatePersistentTrader> HANDLER = new H();
    private static final String GENERATE_ID_FORMAT = "trader_";
    final long traderID;
    final String id;
    final String owner;

    public CPacketCreatePersistentTrader(long traderID, String id, String owner) {
        super(TYPE);
        this.traderID = traderID;
        this.id = id;
        this.owner = owner.isBlank() ? "Minecraft" : owner;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull CPacketCreatePersistentTrader message) {
        buffer.writeLong(message.traderID);
        buffer.writeUtf(message.id);
        buffer.writeUtf(message.owner);
    }

    private static CPacketCreatePersistentTrader decode(@Nonnull FriendlyByteBuf buffer) {
        return new CPacketCreatePersistentTrader(buffer.readLong(), buffer.readUtf(), buffer.readUtf());
    }

    private static class H
    extends CustomPacket.Handler<CPacketCreatePersistentTrader> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(CPacketCreatePersistentTrader::encode, CPacketCreatePersistentTrader::decode));
        }

        @Override
        protected void handle(@Nonnull CPacketCreatePersistentTrader message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            if (LCAdminMode.isAdminPlayer(player)) {
                TraderDataCache data = TraderDataCache.TYPE.get(false);
                if (data == null) {
                    return;
                }
                TraderData trader = data.getTrader(message.traderID);
                if (trader != null && trader.canMakePersistent()) {
                    RegistryAccess lookup = player.registryAccess();
                    boolean generateID = message.id.isBlank();
                    if (!generateID) {
                        try {
                            JsonObject traderJson = trader.saveToJson(message.id, message.owner, (HolderLookup.Provider)lookup);
                            JsonArray persistentTraders = data.getPersistentTraderJson("Traders");
                            for (int i = 0; i < persistentTraders.size(); ++i) {
                                JsonObject traderData = persistentTraders.get(i).getAsJsonObject();
                                if ((!traderData.has("ID") || !traderData.get("ID").getAsString().equals(message.id)) && (!traderData.has("id") || !traderData.get("id").getAsString().equals(message.id))) continue;
                                persistentTraders.set(i, (JsonElement)traderJson);
                                data.setPersistentTraderSection("Traders", persistentTraders, (HolderLookup.Provider)lookup);
                                player.sendSystemMessage((Component)LCText.MESSAGE_PERSISTENT_TRADER_OVERWRITE.get(message.id));
                                return;
                            }
                            persistentTraders.add((JsonElement)traderJson);
                            data.setPersistentTraderSection("Traders", persistentTraders, (HolderLookup.Provider)lookup);
                            player.sendSystemMessage((Component)LCText.MESSAGE_PERSISTENT_TRADER_ADD.get(message.id));
                        }
                        catch (Throwable t) {
                            LightmansCurrency.LogError("Error occurred while creating a persistent trader!", t);
                        }
                    } else {
                        try {
                            int i;
                            ArrayList<String> knownIDs = new ArrayList<String>();
                            JsonArray persistentTraders = data.getPersistentTraderJson("Traders");
                            for (i = 0; i < persistentTraders.size(); ++i) {
                                JsonObject traderData = persistentTraders.get(i).getAsJsonObject();
                                if (traderData.has("id")) {
                                    knownIDs.add(traderData.get("id").getAsString());
                                }
                                if (!traderData.has("ID")) continue;
                                knownIDs.add(traderData.get("ID").getAsString());
                            }
                            for (i = 1; i < Integer.MAX_VALUE; ++i) {
                                String genID = CPacketCreatePersistentTrader.GENERATE_ID_FORMAT + i;
                                if (!knownIDs.stream().noneMatch(id -> id.equals(genID))) continue;
                                persistentTraders.add((JsonElement)trader.saveToJson(genID, message.owner, (HolderLookup.Provider)lookup));
                                data.setPersistentTraderSection("Traders", persistentTraders, (HolderLookup.Provider)lookup);
                                player.sendSystemMessage((Component)LCText.MESSAGE_PERSISTENT_TRADER_ADD.get(genID));
                                return;
                            }
                            LightmansCurrency.LogError("Could not generate ID, as all trader_# ID's are somehow spoken for.");
                        }
                        catch (Throwable t) {
                            LightmansCurrency.LogError("Error occurred while creating a persistent trader!", t);
                        }
                    }
                }
            } else {
                player.sendSystemMessage((Component)LCText.MESSAGE_PERSISTENT_TRADER_FAIL.get(new Object[0]));
            }
        }
    }
}

