/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.trader;

import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.menus.validation.EasyMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.IValidatedMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CPacketOpenTrades
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketOpenTrades> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_trader_menu_trades"));
    public static final CustomPacket.Handler<CPacketOpenTrades> HANDLER = new H();
    private final long traderID;

    public CPacketOpenTrades(long traderID) {
        super(TYPE);
        this.traderID = traderID;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull CPacketOpenTrades message) {
        buffer.writeLong(message.traderID);
    }

    private static CPacketOpenTrades decode(@Nonnull FriendlyByteBuf buffer) {
        return new CPacketOpenTrades(buffer.readLong());
    }

    private static class H
    extends CustomPacket.Handler<CPacketOpenTrades> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(CPacketOpenTrades::encode, CPacketOpenTrades::decode));
        }

        @Override
        protected void handle(@Nonnull CPacketOpenTrades message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof IValidatedMenu) {
                IValidatedMenu tm = (IValidatedMenu)abstractContainerMenu;
                MenuValidator validator = tm.getValidator();
                if (message.traderID < 0L) {
                    player.openMenu(TraderData.getTraderMenuForAllNetworkTraders(validator), EasyMenu.encoder(validator));
                } else {
                    TraderData data = TraderAPI.getApi().GetTrader(false, message.traderID);
                    if (data != null) {
                        data.openTraderMenu(player, validator);
                    }
                }
            }
        }
    }
}

