/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public record WildcardTargetSelector(String testString, TestType test) {
    public boolean matches(String idString) {
        return switch (this.test.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> idString.startsWith(this.testString);
            case 1 -> idString.contains(this.testString);
            case 2 -> idString.endsWith(this.testString);
            case 3 -> idString.equals(this.testString);
        };
    }

    public static WildcardTargetSelector parse(String selector) throws JsonSyntaxException {
        boolean start;
        boolean end = selector.startsWith("*");
        if (end) {
            selector = selector.substring(1);
        }
        if (start = selector.endsWith("*")) {
            selector = selector.substring(0, selector.length() - 1);
        }
        if (start) {
            if (end) {
                return new WildcardTargetSelector(selector, TestType.CONTAINS);
            }
            return new WildcardTargetSelector(selector, TestType.START);
        }
        if (end) {
            return new WildcardTargetSelector(selector, TestType.END);
        }
        return new WildcardTargetSelector(selector, TestType.EQUALS);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.testString, this.test});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof WildcardTargetSelector) {
            WildcardTargetSelector other = (WildcardTargetSelector)obj;
            return other.testString.equals(this.testString) && other.test == this.test;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.test.end) {
            builder.append("*");
        }
        builder.append(this.testString);
        if (this.test.start) {
            builder.append("*");
        }
        return builder.toString();
    }

    public static enum TestType {
        START(true, false),
        CONTAINS(true, true),
        END(false, true),
        EQUALS(false, false);

        final boolean start;
        final boolean end;

        private TestType(boolean start, boolean end) {
            this.start = start;
            this.end = end;
        }
    }
}

