/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.icons;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.GsonHelper;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MultiIcon
extends IconData {
    public static final IconData.Type TYPE = new IconData.Type(VersionUtil.lcResource("multi_icon"), MultiIcon::loadMulti, MultiIcon::parseMulti);
    private final List<IconData> icons;

    private MultiIcon(List<IconData> icons) {
        super(TYPE);
        this.icons = icons;
    }

    public static IconData ofMultiple(IconData ... icons) {
        return MultiIcon.ofMultiple((List<IconData>)ImmutableList.copyOf((Object[])icons));
    }

    public static IconData ofMultiple(List<IconData> list) {
        return new MultiIcon((List<IconData>)ImmutableList.copyOf(list));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(EasyGuiGraphics gui, int x, int y) {
        for (IconData icon : this.icons) {
            icon.render(gui, x, y);
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        ListTag children = new ListTag();
        for (IconData icon : this.icons) {
            children.add((Object)icon.save(lookup));
        }
        tag.put("Children", (Tag)children);
    }

    @Override
    protected void writeAdditional(JsonObject json, HolderLookup.Provider lookup) {
        JsonArray children = new JsonArray();
        for (IconData icon : this.icons) {
            children.add((JsonElement)icon.write(lookup));
        }
        json.add("Children", (JsonElement)children);
    }

    private static IconData loadMulti(CompoundTag tag, HolderLookup.Provider lookup) {
        ArrayList<IconData> result = new ArrayList<IconData>();
        ListTag children = tag.getList("Children", 10);
        for (int i = 0; i < children.size(); ++i) {
            IconData icon = MultiIcon.load(children.getCompound(i), lookup);
            if (icon == null) continue;
            result.add(icon);
        }
        return new MultiIcon(result);
    }

    private static IconData parseMulti(JsonObject json, HolderLookup.Provider lookup) {
        ArrayList<IconData> result = new ArrayList<IconData>();
        JsonArray children = GsonHelper.getAsJsonArray((JsonObject)json, (String)"Children");
        for (int i = 0; i < children.size(); ++i) {
            result.add(MultiIcon.parse(GsonHelper.convertToJsonObject((JsonElement)children.get(i), (String)("Children[" + i + "]")), lookup));
        }
        return new MultiIcon(result);
    }
}

