/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.network;

import com.google.common.collect.ImmutableMap;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.common.util.TagUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.TriConsumer;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class LazyPacketData {
    public static final byte TYPE_NULL = 0;
    public static final byte TYPE_BOOLEAN = 1;
    public static final byte TYPE_INT = 2;
    public static final byte TYPE_LONG = 3;
    public static final byte TYPE_FLOAT = 4;
    public static final byte TYPE_DOUBLE = 5;
    public static final byte TYPE_STRING = 6;
    public static final byte TYPE_UUID = 32;
    public static final byte TYPE_TEXT = 64;
    public static final byte TYPE_NBT = 65;
    private final ImmutableMap<String, Data> dataMap;
    public final HolderLookup.Provider lookup;

    private LazyPacketData(Map<String, Data> data, HolderLookup.Provider lookup) {
        this.dataMap = ImmutableMap.copyOf(data);
        this.lookup = lookup;
    }

    private Data getData(String key) {
        return (Data)this.dataMap.getOrDefault((Object)key, (Object)Data.NULL);
    }

    public boolean contains(String key) {
        return this.dataMap.containsKey((Object)key);
    }

    public boolean contains(String key, byte type) {
        return this.contains(key) && this.getData((String)key).type == type;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Data d = this.getData(key);
        if (d.type == 1) {
            return (Boolean)d.value;
        }
        return defaultValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        Data d = this.getData(key);
        if (d.type == 2) {
            return (Integer)d.value;
        }
        return defaultValue;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        Data d = this.getData(key);
        if (d.type == 3) {
            return (Long)d.value;
        }
        return defaultValue;
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        Data d = this.getData(key);
        if (d.type == 4) {
            return ((Float)d.value).floatValue();
        }
        return defaultValue;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        Data d = this.getData(key);
        if (d.type == 5) {
            return (Double)d.value;
        }
        return defaultValue;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        Data d = this.getData(key);
        if (d.type == 6) {
            return (String)d.value;
        }
        return defaultValue;
    }

    public UUID getUUID(String key) {
        return this.getUUID(key, null);
    }

    public UUID getUUID(String key, UUID defaultValue) {
        Data d = this.getData(key);
        if (d.type == 32) {
            return (UUID)d.value;
        }
        return defaultValue;
    }

    public ResourceLocation getResourceLocation(String key) {
        return this.getResourceLocation(key, null);
    }

    public ResourceLocation getResourceLocation(String key, ResourceLocation defaultValue) {
        Data d = this.getData(key);
        if (d.type == 6) {
            return VersionUtil.parseResource((String)d.value);
        }
        return defaultValue;
    }

    public Component getText(String key) {
        return this.getText(key, (Component)EasyText.empty());
    }

    public Component getText(String key, Component defaultValue) {
        Data d = this.getData(key);
        if (d.type == 64) {
            return (Component)d.value;
        }
        return defaultValue;
    }

    public CompoundTag getNBT(String key) {
        return this.getNBT(key, new CompoundTag());
    }

    public CompoundTag getNBT(String key, CompoundTag defaultValue) {
        Data d = this.getData(key);
        if (d.type == 65) {
            return (CompoundTag)d.value;
        }
        return defaultValue;
    }

    public BlockPos getBlockPos(String key) {
        return this.getBlockPos(key, BlockPos.ZERO);
    }

    public BlockPos getBlockPos(String key, BlockPos defaultValue) {
        Data d = this.getData(key);
        if (d.type == 65) {
            return TagUtil.loadBlockPos((CompoundTag)d.value);
        }
        return defaultValue;
    }

    public ItemStack getItem(String key) {
        return this.getItem(key, ItemStack.EMPTY);
    }

    public ItemStack getItem(String key, ItemStack defaultValue) {
        Data d = this.getData(key);
        if (d.type == 65) {
            return InventoryUtil.loadItemNoLimits((CompoundTag)d.value, this.lookup);
        }
        return defaultValue;
    }

    public MoneyValue getMoneyValue(String key) {
        return this.getMoneyValue(key, MoneyValue.empty());
    }

    public MoneyValue getMoneyValue(String key, MoneyValue defaultValue) {
        Data d = this.getData(key);
        if (d.type == 65) {
            return MoneyValue.load((CompoundTag)d.value);
        }
        return defaultValue;
    }

    public Owner getOwner(String key) {
        return this.getOwner(key, null);
    }

    public Owner getOwner(String key, Owner defaultValue) {
        Data d = this.getData(key);
        if (d.type == 65) {
            return Owner.load((CompoundTag)d.value, this.lookup);
        }
        return defaultValue;
    }

    public <T> List<T> getList(String key, BiFunction<LazyPacketData, String, T> reader) {
        return this.getList(key, new ArrayList(), reader);
    }

    public <T> List<T> getList(String key, List<T> defaultValue, BiFunction<LazyPacketData, String, T> reader) {
        String thisKey;
        if (!this.contains(key)) {
            return defaultValue;
        }
        ArrayList<T> list = new ArrayList<T>();
        int index = 0;
        while (this.contains(thisKey = key + "_" + index++)) {
            list.add(reader.apply(this, thisKey));
        }
        return list;
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.dataMap.size());
        this.dataMap.forEach((key, data) -> {
            buffer.writeUtf(key, 100);
            buffer.writeByte(data.type);
            data.encode(buffer);
        });
    }

    public static LazyPacketData decode(RegistryFriendlyByteBuf buffer) {
        int count = buffer.readInt();
        HashMap<String, Data> dataMap = new HashMap<String, Data>();
        for (int i = 0; i < count; ++i) {
            String key = buffer.readUtf(100);
            Data data = Data.decode(buffer);
            dataMap.put(key, data);
        }
        return new LazyPacketData(dataMap, (HolderLookup.Provider)buffer.registryAccess());
    }

    public Builder copyToBuilder() {
        Builder b = new Builder(this.lookup);
        this.dataMap.forEach(b::addData);
        return b;
    }

    public int size() {
        return this.dataMap.size();
    }

    public int size(@Nullable String ignoreKey) {
        int size = this.dataMap.size();
        if (ignoreKey != null && this.contains(ignoreKey)) {
            return size - 1;
        }
        return size;
    }

    public static Builder builder(HolderLookup.Provider lookup) {
        return new Builder(lookup);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("LazyPacketData[");
        AtomicBoolean notFirst = new AtomicBoolean(false);
        this.dataMap.forEach((key, val) -> {
            if (notFirst.get()) {
                builder.append(",");
            }
            builder.append((String)key).append(":");
            builder.append(val);
            notFirst.set(true);
        });
        return builder.append("]").toString();
    }

    private record Data(byte type, Object value) {
        static final Data NULL = new Data(0, null);

        static Data ofNull() {
            return NULL;
        }

        static Data ofBoolean(boolean value) {
            return new Data(1, value);
        }

        static Data ofInt(int value) {
            return new Data(2, value);
        }

        static Data ofLong(long value) {
            return new Data(3, value);
        }

        static Data ofFloat(float value) {
            return new Data(4, Float.valueOf(value));
        }

        static Data ofDouble(double value) {
            return new Data(5, value);
        }

        static Data ofString(@Nullable String value) {
            return value == null ? NULL : new Data(6, value);
        }

        static Data ofUUID(@Nullable UUID value) {
            return value == null ? NULL : new Data(32, value);
        }

        static Data ofResourceLocation(@Nullable ResourceLocation value) {
            return value == null ? NULL : new Data(6, value.toString());
        }

        static Data ofText(@Nullable Component value) {
            return value == null ? NULL : new Data(64, value);
        }

        static Data ofNBT(@Nullable CompoundTag value) {
            return value == null ? NULL : new Data(65, value);
        }

        static Data ofBlockPos(@Nullable BlockPos value) {
            return value == null ? NULL : new Data(65, TagUtil.saveBlockPos(value));
        }

        static Data ofItem(@Nullable ItemStack value, HolderLookup.Provider lookup) {
            return value == null ? NULL : Data.ofNBT(InventoryUtil.saveItemNoLimits(value, lookup));
        }

        static Data ofMoneyValue(@Nullable MoneyValue value, HolderLookup.Provider lookup) {
            if (value == null) {
                return NULL;
            }
            CompoundTag tag = value.save();
            return Data.ofNBT(tag);
        }

        static Data ofOwner(@Nullable Owner value, HolderLookup.Provider lookup) {
            if (value == null) {
                return NULL;
            }
            CompoundTag tag = value.save(lookup);
            return Data.ofNBT(tag);
        }

        void encode(RegistryFriendlyByteBuf buffer) {
            if (this.type == 1) {
                buffer.writeBoolean(((Boolean)this.value).booleanValue());
            }
            if (this.type == 2) {
                buffer.writeInt(((Integer)this.value).intValue());
            }
            if (this.type == 3) {
                buffer.writeLong(((Long)this.value).longValue());
            }
            if (this.type == 4) {
                buffer.writeFloat(((Float)this.value).floatValue());
            }
            if (this.type == 5) {
                buffer.writeDouble(((Double)this.value).doubleValue());
            }
            if (this.type == 6) {
                int length = ((String)this.value).length();
                buffer.writeInt(length);
                buffer.writeUtf((String)this.value, length);
            }
            if (this.type == 32) {
                buffer.writeUUID((UUID)this.value);
            }
            if (this.type == 64) {
                ComponentSerialization.STREAM_CODEC.encode((Object)buffer, (Object)((Component)this.value));
            }
            if (this.type == 65) {
                buffer.writeNbt((Tag)((CompoundTag)this.value));
            }
        }

        static Data decode(RegistryFriendlyByteBuf buffer) {
            byte type = buffer.readByte();
            if (type == 0) {
                return Data.ofNull();
            }
            if (type == 1) {
                return Data.ofBoolean(buffer.readBoolean());
            }
            if (type == 2) {
                return Data.ofInt(buffer.readInt());
            }
            if (type == 3) {
                return Data.ofLong(buffer.readLong());
            }
            if (type == 4) {
                return Data.ofFloat(buffer.readFloat());
            }
            if (type == 5) {
                return Data.ofDouble(buffer.readDouble());
            }
            if (type == 6) {
                int length = buffer.readInt();
                return Data.ofString(buffer.readUtf(length));
            }
            if (type == 32) {
                return Data.ofUUID(buffer.readUUID());
            }
            if (type == 64) {
                return Data.ofText((Component)ComponentSerialization.STREAM_CODEC.decode((Object)buffer));
            }
            if (type == 65) {
                return Data.ofNBT((CompoundTag)buffer.readNbt(NbtAccounter.unlimitedHeap()));
            }
            throw new RuntimeException("Could not decode entry of type " + type + "as it is not a valid data entry type!");
        }

        @Override
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static final class Builder {
        private final HolderLookup.Provider lookup;
        Map<String, Data> data = new HashMap<String, Data>();

        private Builder(HolderLookup.Provider lookup) {
            this.lookup = lookup;
        }

        private void addData(String key, Data data) {
            this.data.put(key, data);
        }

        public Builder setFlag(String key) {
            this.data.put(key, Data.ofBoolean(true));
            return this;
        }

        public Builder setBoolean(String key, boolean value) {
            this.data.put(key, Data.ofBoolean(value));
            return this;
        }

        public Builder setInt(String key, int value) {
            this.data.put(key, Data.ofInt(value));
            return this;
        }

        public Builder setLong(String key, long value) {
            this.data.put(key, Data.ofLong(value));
            return this;
        }

        public Builder setFloat(String key, float value) {
            this.data.put(key, Data.ofFloat(value));
            return this;
        }

        public Builder setDouble(String key, double value) {
            this.data.put(key, Data.ofDouble(value));
            return this;
        }

        public Builder setString(String key, String value) {
            this.data.put(key, Data.ofString(value));
            return this;
        }

        public Builder setUUID(String key, UUID uuid) {
            this.data.put(key, Data.ofUUID(uuid));
            return this;
        }

        public Builder setResourceLocation(String key, ResourceLocation value) {
            this.data.put(key, Data.ofString(value.toString()));
            return this;
        }

        public Builder setText(String key, Component value) {
            this.data.put(key, Data.ofText(value));
            return this;
        }

        public Builder setCompound(String key, CompoundTag value) {
            this.data.put(key, Data.ofNBT(value));
            return this;
        }

        public Builder setBlockPos(String key, BlockPos value) {
            this.data.put(key, Data.ofBlockPos(value));
            return this;
        }

        public Builder setItem(String key, ItemStack value) {
            this.data.put(key, Data.ofItem(value, this.lookup));
            return this;
        }

        public Builder setMoneyValue(String key, MoneyValue value) {
            this.data.put(key, Data.ofMoneyValue(value, this.lookup));
            return this;
        }

        public Builder setOwner(String key, Owner value) {
            this.data.put(key, Data.ofOwner(value, this.lookup));
            return this;
        }

        public <T> Builder setList(String key, List<T> list, TriConsumer<Builder, String, T> writer) {
            this.setFlag(key);
            for (int i = 0; i < list.size(); ++i) {
                writer.accept(this, key + "_" + i, list.get(i));
            }
            return this;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("LazyPacketData$Builder[");
            AtomicBoolean notFirst = new AtomicBoolean(false);
            this.data.forEach((key, val) -> {
                if (notFirst.get()) {
                    builder.append(",");
                }
                builder.append((String)key).append(":");
                builder.append(val.toString());
                notFirst.set(true);
            });
            return builder.append("]").toString();
        }

        public LazyPacketData build() {
            return new LazyPacketData(this.data, this.lookup);
        }
    }

    public static interface IBuilderProvider {
        public Builder builder();
    }
}

