/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.taxes.notifications;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationAPI;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.notifications.SingleLineNotification;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;

public class TaxesPaidNotification
extends SingleLineNotification {
    public static final NotificationType<TaxesPaidNotification> TYPE = new NotificationType<TaxesPaidNotification>(VersionUtil.lcResource("taxes_paid"), TaxesPaidNotification::new);
    private MoneyValue amount = MoneyValue.empty();
    private NotificationCategory category = NotificationCategory.GENERAL;

    private TaxesPaidNotification() {
    }

    private TaxesPaidNotification(MoneyValue amount, NotificationCategory category) {
        this.amount = amount;
        this.category = category;
    }

    public static Supplier<Notification> create(MoneyValue amount, NotificationCategory category) {
        return () -> new TaxesPaidNotification(amount, category);
    }

    @Nonnull
    protected NotificationType<TaxesPaidNotification> getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public NotificationCategory getCategory() {
        return this.category;
    }

    @Nonnull
    public MutableComponent getMessage() {
        if (this.amount.isEmpty()) {
            return LCText.NOTIFICATION_TAXES_PAID_NULL.get(new Object[0]);
        }
        return LCText.NOTIFICATION_TAXES_PAID.get(this.amount.getText());
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        compound.put("Amount", (Tag)this.amount.save());
        compound.put("Category", (Tag)this.category.save(lookup));
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        this.amount = MoneyValue.load(compound.getCompound("Amount"));
        this.category = NotificationAPI.getApi().LoadCategory(compound.getCompound("Category"), lookup);
    }

    @Override
    protected boolean canMerge(@Nonnull Notification other) {
        if (other instanceof TaxesPaidNotification) {
            TaxesPaidNotification tpn = (TaxesPaidNotification)other;
            return tpn.amount.equals(this.amount) && tpn.category.matches(this.category);
        }
        return false;
    }
}

