/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.teams;

import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.common.impl.TeamAPIImpl;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class TeamAPI {
    private static TeamAPI instance;

    public static TeamAPI getApi() {
        if (instance == null) {
            instance = new TeamAPIImpl();
        }
        return instance;
    }

    protected TeamAPI() {
        if (instance != null) {
            throw new IllegalCallerException("Cannot create a new TeamAPI instance as one is already present!");
        }
    }

    @Nullable
    public abstract ITeam GetTeam(boolean var1, long var2);

    @Nullable
    public final ITeam GetTeam(IClientTracker context, long teamID) {
        return this.GetTeam(context.isClient(), teamID);
    }

    public abstract List<ITeam> GetAllTeams(boolean var1);

    public final List<ITeam> GetAllTeams(IClientTracker context) {
        return this.GetAllTeams(context.isClient());
    }

    public abstract List<ITeam> GetAllTeamsForPlayer(Player var1);

    @Nullable
    public abstract ITeam CreateTeam(Player var1, String var2);

    public abstract Comparator<ITeam> SorterForPlayer(Player var1);
}

