/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.terminal;

import io.github.lightman314.lightmanscurrency.api.traders.terminal.PendingSearch;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

@ParametersAreNonnullByDefault
public interface ITradeSearchFilter {
    public void filterTrade(TradeData var1, PendingSearch var2, HolderLookup.Provider var3);

    public static boolean filterItem(ItemStack stack, String searchText, HolderLookup.Provider lookup) {
        if (!stack.isEmpty()) {
            if (stack.getHoverName().getString().toLowerCase().contains(searchText)) {
                return true;
            }
            if (BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString().toLowerCase().contains(searchText)) {
                return true;
            }
            ItemEnchantments enchantments = stack.getItem() == Items.ENCHANTED_BOOK ? (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY) : stack.getAllEnchantments(lookup.lookupOrThrow(Registries.ENCHANTMENT));
            for (Object2IntMap.Entry ench : enchantments.entrySet()) {
                if (Enchantment.getFullname((Holder)((Holder)ench.getKey()), (int)ench.getIntValue()).getString().toLowerCase().contains(searchText)) {
                    return true;
                }
                if (!((Holder)ench.getKey()).getRegisteredName().toLowerCase().contains(searchText)) continue;
                return true;
            }
        }
        return false;
    }
}

