/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.custom_models.tests;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.custom_models.CustomModelTest;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.custom_models.NestedModelTest;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.custom_models.tests.AndTest;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class OrTest
extends NestedModelTest {
    public static final ResourceLocation TYPE = VersionUtil.lcResource("or");
    private final List<CustomModelTest> tests;

    public OrTest(CustomModelTest ... tests) {
        this((List<CustomModelTest>)ImmutableList.copyOf((Object[])tests));
    }

    public OrTest(List<CustomModelTest> tests) {
        super(TYPE);
        this.tests = ImmutableList.copyOf(tests);
        this.checkForInfiniteLoops();
    }

    @Override
    public boolean test(ItemTraderBlockEntity blockEntity, ItemStack item) {
        for (CustomModelTest test : this.tests) {
            if (!test.test(blockEntity, item)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        JsonArray list = new JsonArray();
        for (CustomModelTest test : this.tests) {
            list.add((JsonElement)test.write());
        }
        json.add("children", (JsonElement)list);
    }

    @Override
    protected List<CustomModelTest> children() {
        return this.tests;
    }

    public static AndTest parse(JsonObject json) throws JsonSyntaxException, ResourceLocationException {
        JsonArray list = GsonHelper.getAsJsonArray((JsonObject)json, (String)"children");
        ArrayList<CustomModelTest> tests = new ArrayList<CustomModelTest>();
        for (int i = 0; i < list.size(); ++i) {
            JsonObject entry = GsonHelper.convertToJsonObject((JsonElement)list.get(i), (String)("children[" + i + "]"));
            tests.add(CustomModelTest.parse(entry));
        }
        return new AndTest(tests);
    }
}

