/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage.paygate;

import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettingsState;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.paygate.PaygateTradeEditClientTab;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.PaygateTradeData;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PaygateTradeEditTab
extends TraderStorageTab {
    private int tradeIndex = -1;

    public PaygateTradeEditTab(@Nonnull ITraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(@Nonnull Object screen) {
        return new PaygateTradeEditClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return ((ITraderStorageMenu)this.menu).hasPermission("editTrades");
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public PaygateTradeData getTrade() {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof PaygateTraderData) {
            PaygateTraderData paygate = (PaygateTraderData)traderData;
            if (this.tradeIndex >= paygate.getTradeCount() || this.tradeIndex < 0) {
                ((ITraderStorageMenu)this.menu).ChangeTab(0);
                return null;
            }
            return paygate.getTrade(this.tradeIndex);
        }
        return null;
    }

    public void setPrice(MoneyValue price) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setCost(price);
            ((ITraderStorageMenu)this.menu).getTrader().markTradesDirty();
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setMoneyValue("NewPrice", price));
            }
        }
    }

    public void setTicket(ItemStack ticket) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setTicket(ticket);
            ((ITraderStorageMenu)this.menu).getTrader().markTradesDirty();
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setBoolean("NewTicket", true).setItem("Ticket", ticket));
            }
        }
    }

    public void setDuration(int duration) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setDuration(duration);
            ((ITraderStorageMenu)this.menu).getTrader().markTradesDirty();
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setInt("NewDuration", duration));
            }
        }
    }

    public void setLevel(int level) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setRedstoneLevel(level);
            ((ITraderStorageMenu)this.menu).getTrader().markTradesDirty();
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setInt("NewLevel", level));
            }
        }
    }

    public void setDescription(String description) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setDescription(description);
            ((ITraderStorageMenu)this.menu).getTrader().markTradesDirty();
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setString("NewDescription", description));
            }
        }
    }

    public void setTooltip(String tooltip) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setTooltip(tooltip);
            ((ITraderStorageMenu)this.menu).getTrader().markTradesDirty();
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setString("NewTooltip", tooltip));
            }
        }
    }

    public void setTicketStubHandling(boolean storeTicketStubs) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setStoreTicketStubs(storeTicketStubs);
            ((ITraderStorageMenu)this.menu).getTrader().markTradesDirty();
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setBoolean("StoreTicketStubs", storeTicketStubs));
            }
        }
    }

    public void setOutputSide(Direction side, DirectionalSettingsState state) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.getOutputSides().setState(side, state);
            ((ITraderStorageMenu)this.menu).getTrader().markTradesDirty();
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setInt("SetOutputSide", side.get3DDataValue()).setString("State", state.toString()));
            }
        }
    }

    @Override
    public void OpenMessage(@Nonnull LazyPacketData message) {
        if (message.contains("TradeIndex")) {
            this.tradeIndex = message.getInt("TradeIndex");
        }
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("NewPrice")) {
            this.setPrice(message.getMoneyValue("NewPrice"));
        } else if (message.contains("NewTicket")) {
            ItemStack ticket = ItemStack.EMPTY;
            if (message.contains("Ticket")) {
                ticket = message.getItem("Ticket");
            }
            this.setTicket(ticket);
        } else if (message.contains("NewDuration")) {
            this.setDuration(message.getInt("NewDuration"));
        } else if (message.contains("NewLevel")) {
            this.setLevel(message.getInt("NewLevel"));
        } else if (message.contains("NewDescription")) {
            this.setDescription(message.getString("NewDescription"));
        } else if (message.contains("NewTooltip")) {
            this.setTooltip(message.getString("NewTooltip"));
        } else if (message.contains("StoreTicketStubs")) {
            this.setTicketStubHandling(message.getBoolean("StoreTicketStubs"));
        } else if (message.contains("SetOutputSide")) {
            Direction side = Direction.from3DDataValue((int)message.getInt("SetOutputSide"));
            DirectionalSettingsState state = DirectionalSettingsState.parse(message.getString("State"));
            this.setOutputSide(side, state);
        }
    }
}

