/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.auction;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.AuctionHouseCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.data.ItemData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class AuctionHouseSellerNotification
extends Notification {
    public static final NotificationType<AuctionHouseSellerNotification> TYPE = new NotificationType<AuctionHouseSellerNotification>(VersionUtil.lcResource("auction_house_seller"), AuctionHouseSellerNotification::new);
    List<ItemData> items;
    MoneyValue highestBid = MoneyValue.empty();
    MoneyValue payment = MoneyValue.empty();
    MoneyValue fee = MoneyValue.empty();
    String customer;

    private AuctionHouseSellerNotification() {
    }

    public AuctionHouseSellerNotification(AuctionTradeData trade, MoneyValue payment, MoneyValue fee) {
        this.highestBid = trade.getLastBidAmount();
        this.payment = payment;
        this.fee = fee;
        this.customer = trade.getLastBidPlayer().getName(false);
        this.items = new ArrayList<ItemData>();
        for (int i = 0; i < trade.getAuctionItems().size(); ++i) {
            this.items.add(new ItemData(trade.getAuctionItems().get(i)));
        }
    }

    protected NotificationType<AuctionHouseSellerNotification> getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return AuctionHouseCategory.INSTANCE;
    }

    @Override
    public List<Component> getMessageLines() {
        Component itemText = ItemData.getItemNames(this.items);
        MutableComponent cost = this.highestBid.getText("0");
        MutableComponent line1 = LCText.NOTIFICATION_AUCTION_SELLER.get(this.customer, itemText, cost);
        if (this.fee.isEmpty()) {
            return List.of(line1);
        }
        MutableComponent line2 = LCText.NOTIFICATION_AUCTION_SELLER_FEE.get(this.payment.getText("0"), this.fee.getText("0"));
        return List.of(line1, line2);
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        ListTag itemList = new ListTag();
        for (ItemData item : this.items) {
            itemList.add((Object)item.save(lookup));
        }
        compound.put("Items", (Tag)itemList);
        compound.put("Price", (Tag)this.highestBid.save());
        if (!this.fee.isEmpty()) {
            compound.put("Payment", (Tag)this.payment.save());
            compound.put("Fee", (Tag)this.fee.save());
        }
        compound.putString("Customer", this.customer);
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        ListTag itemList = compound.getList("Items", 10);
        this.items = new ArrayList<ItemData>();
        for (int i = 0; i < itemList.size(); ++i) {
            this.items.add(ItemData.load(itemList.getCompound(i), lookup));
        }
        this.highestBid = MoneyValue.safeLoad(compound, "Price");
        if (compound.contains("Payment") && compound.contains("Fee")) {
            this.payment = MoneyValue.load(compound.getCompound("Payment"));
            this.fee = MoneyValue.load(compound.getCompound("Fee"));
        }
        this.customer = compound.getString("Customer");
    }

    @Override
    protected boolean canMerge(Notification other) {
        return false;
    }
}

