/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.villager_merchant.listings;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.ItemListingSerializer;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.ItemsForXTradeTemplate;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class ItemsForMapTrade
extends ItemsForXTradeTemplate {
    public static final ResourceLocation TYPE = VersionUtil.lcResource("items_for_map");
    public static final Serializer SERIALIZER = new Serializer();
    protected final TagKey<Structure> destination;
    protected final String displayName;
    protected final Holder<MapDecorationType> mapDecorationType;

    public ItemsForMapTrade(ItemStack price, TagKey<Structure> destination, String displayName, Holder<MapDecorationType> mapDecorationType, int maxUses, int xpValue) {
        this(price, ItemStack.EMPTY, destination, displayName, mapDecorationType, maxUses, xpValue, 0.05f);
    }

    public ItemsForMapTrade(ItemStack price1, ItemStack price2, TagKey<Structure> destination, String displayName, Holder<MapDecorationType> mapDecorationType, int maxUses, int xpValue, float priceMult) {
        super(price1, price2, maxUses, xpValue, priceMult);
        this.destination = destination;
        this.displayName = displayName;
        this.mapDecorationType = mapDecorationType;
    }

    private ItemsForMapTrade(@Nonnull ItemsForXTradeTemplate.DeserializedData data, TagKey<Structure> destination, String displayName, Holder<MapDecorationType> mapDecorationType) {
        super(data);
        this.destination = destination;
        this.displayName = displayName;
        this.mapDecorationType = mapDecorationType;
    }

    @Override
    protected ItemStack createResult(@Nonnull Entity trader, @Nonnull RandomSource rand) {
        Level level;
        if (trader == null || !((level = trader.level()) instanceof ServerLevel)) {
            return null;
        }
        ServerLevel level2 = (ServerLevel)level;
        BlockPos blockPos = level2.findNearestMapStructure(this.destination, trader.blockPosition(), 100, true);
        if (blockPos != null) {
            ItemStack itemstack = MapItem.create((Level)level2, (int)blockPos.getX(), (int)blockPos.getZ(), (byte)2, (boolean)true, (boolean)true);
            MapItem.lockMap((Level)level2, (ItemStack)itemstack);
            MapItemSavedData.addTargetDecoration((ItemStack)itemstack, (BlockPos)blockPos, (String)"+", this.mapDecorationType);
            itemstack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)this.displayName));
            return itemstack;
        }
        return null;
    }

    public static class Serializer
    implements ItemListingSerializer.IItemListingSerializer,
    ItemListingSerializer.IItemListingDeserializer {
        private Serializer() {
        }

        @Override
        public ResourceLocation getType() {
            return TYPE;
        }

        @Override
        @Nonnull
        public JsonObject serializeInternal(@Nonnull JsonObject json, @Nonnull VillagerTrades.ItemListing trade, @Nonnull HolderLookup.Provider lookup) {
            if (trade instanceof ItemsForMapTrade) {
                ItemsForMapTrade t = (ItemsForMapTrade)trade;
                t.serializeData(json, lookup);
                json.addProperty("Destination", t.destination.location().toString());
                json.addProperty("MapName", t.displayName);
                json.addProperty("Decoration", BuiltInRegistries.MAP_DECORATION_TYPE.getKey((Object)((MapDecorationType)t.mapDecorationType.value())).toString());
                return json;
            }
            return null;
        }

        @Override
        @Nonnull
        public VillagerTrades.ItemListing deserialize(@Nonnull JsonObject json, @Nonnull HolderLookup.Provider lookup) throws JsonSyntaxException, ResourceLocationException {
            ItemsForXTradeTemplate.DeserializedData data = ItemsForXTradeTemplate.deserializeData(json, lookup);
            TagKey destination = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)VersionUtil.parseResource(GsonHelper.getAsString((JsonObject)json, (String)"Destination")));
            String displayName = GsonHelper.getAsString((JsonObject)json, (String)"MapName");
            Holder mapDecorationType = (Holder)BuiltInRegistries.MAP_DECORATION_TYPE.getHolder(VersionUtil.parseResource(GsonHelper.getAsString((JsonObject)json, (String)"Decoration"))).orElseThrow(() -> new JsonSyntaxException(GsonHelper.getAsString((JsonObject)json, (String)"Decoration") + " is not a valid decoration type!"));
            return new ItemsForMapTrade(data, (TagKey<Structure>)destination, displayName, (Holder<MapDecorationType>)mapDecorationType);
        }
    }
}

