/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message;

import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CPacketRequestNBT
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketRequestNBT> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_request_block_nbt"));
    public static final CustomPacket.Handler<CPacketRequestNBT> HANDLER = new H();
    private final BlockPos pos;

    public CPacketRequestNBT(BlockPos pos) {
        super(TYPE);
        this.pos = pos;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull CPacketRequestNBT message) {
        buffer.writeBlockPos(message.pos);
    }

    private static CPacketRequestNBT decode(@Nonnull FriendlyByteBuf buffer) {
        return new CPacketRequestNBT(buffer.readBlockPos());
    }

    private static class H
    extends CustomPacket.Handler<CPacketRequestNBT> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(CPacketRequestNBT::encode, CPacketRequestNBT::decode));
        }

        @Override
        protected void handle(@Nonnull CPacketRequestNBT message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            BlockEntity blockEntity = player.level().getBlockEntity(message.pos);
            if (blockEntity != null) {
                BlockEntityUtil.sendUpdatePacket(blockEntity, player);
            }
        }
    }
}

