/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.config;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.MapLikeOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SPacketEditMapConfig
extends ServerToClientPacket {
    private static final CustomPacketPayload.Type<SPacketEditMapConfig> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("s_config_edit_map"));
    public static final CustomPacket.Handler<SPacketEditMapConfig> HANDLER = new H();
    private final ResourceLocation fileID;
    private final String option;
    private final String input;
    private final String key;
    private final boolean isSet;

    public SPacketEditMapConfig(@Nonnull ResourceLocation fileID, @Nonnull String option, @Nonnull String input, String key, boolean isSet) {
        super(TYPE);
        this.fileID = fileID;
        this.option = option;
        this.input = input;
        this.key = key;
        this.isSet = isSet;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull SPacketEditMapConfig message) {
        buffer.writeResourceLocation(message.fileID);
        buffer.writeUtf(message.option);
        buffer.writeUtf(message.input);
        buffer.writeUtf(message.key);
        buffer.writeBoolean(message.isSet);
    }

    private static SPacketEditMapConfig decode(@Nonnull FriendlyByteBuf buffer) {
        return new SPacketEditMapConfig(buffer.readResourceLocation(), buffer.readUtf(), buffer.readUtf(), buffer.readUtf(), buffer.readBoolean());
    }

    private static class H
    extends CustomPacket.Handler<SPacketEditMapConfig> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(SPacketEditMapConfig::encode, SPacketEditMapConfig::decode));
        }

        @Override
        protected void handle(@Nonnull SPacketEditMapConfig message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            ConfigFile file = ConfigFile.lookupFile(message.fileID);
            if (file != null && file.isClientOnly()) {
                ConfigOption<?> configOption;
                Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
                if (optionMap.containsKey(message.option) && (configOption = optionMap.get(message.option)) instanceof MapLikeOption) {
                    MapLikeOption option = (MapLikeOption)configOption;
                    Pair<Boolean, ConfigParsingException> result = option.editMap(message.input, message.key, message.isSet);
                    if (!((Boolean)result.getFirst()).booleanValue()) {
                        LightmansCurrency.getProxy().sendClientMessage((Component)LCText.COMMAND_CONFIG_EDIT_FAIL_PARSE.get(((ConfigParsingException)result.getSecond()).getMessage()).withStyle(ChatFormatting.RED));
                        return;
                    }
                    if (!message.isSet) {
                        LightmansCurrency.getProxy().sendClientMessage((Component)LCText.COMMAND_CONFIG_EDIT_LIST_REMOVE_SUCCESS.get(message.option + "[" + message.key + "]"));
                    }
                    LightmansCurrency.getProxy().sendClientMessage((Component)LCText.COMMAND_CONFIG_EDIT_SUCCESS.get(message.option + "[" + message.key + "]", message.input));
                    return;
                }
                LightmansCurrency.getProxy().sendClientMessage((Component)LCText.COMMAND_CONFIG_FAIL_MISSING.get(message.option).withStyle(ChatFormatting.RED));
            }
        }
    }
}

