/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.walletslot;

import io.github.lightman314.lightmanscurrency.common.attachments.WalletHandler;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SPacketSyncWallet
extends ServerToClientPacket {
    private static final CustomPacketPayload.Type<SPacketSyncWallet> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("s_wallet_sync"));
    public static final CustomPacket.Handler<SPacketSyncWallet> HANDLER = new H();
    int entityID;
    ItemStack walletItem;
    boolean visible;

    public SPacketSyncWallet(int entityID, ItemStack wallet, boolean visible) {
        super(TYPE);
        this.entityID = entityID;
        this.walletItem = wallet;
        this.visible = visible;
    }

    private static void encode(@Nonnull RegistryFriendlyByteBuf buffer, @Nonnull SPacketSyncWallet message) {
        buffer.writeInt(message.entityID);
        SPacketSyncWallet.writeItem(buffer, message.walletItem);
        buffer.writeBoolean(message.visible);
    }

    private static SPacketSyncWallet decode(@Nonnull RegistryFriendlyByteBuf buffer) {
        return new SPacketSyncWallet(buffer.readInt(), SPacketSyncWallet.readItem(buffer), buffer.readBoolean());
    }

    private static class H
    extends CustomPacket.Handler<SPacketSyncWallet> {
        protected H() {
            super(TYPE, CustomPacket.fancyCodec(SPacketSyncWallet::encode, SPacketSyncWallet::decode));
        }

        @Override
        protected void handle(@Nonnull SPacketSyncWallet message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            Entity entity = player.level().getEntity(message.entityID);
            if (entity instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                WalletHandler walletHandler = WalletHandler.get(entity2);
                walletHandler.syncWallet(message.walletItem);
                walletHandler.setVisible(message.visible);
            }
        }
    }
}

