/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.ejection.builtin;

import io.github.lightman314.lightmanscurrency.api.ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.api.ejection.EjectionDataType;
import io.github.lightman314.lightmanscurrency.api.misc.player.OwnerData;
import io.github.lightman314.lightmanscurrency.common.menus.containers.NonEmptyContainer;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;

public class BasicEjectionData
extends EjectionData {
    public static final EjectionDataType TYPE = new Type();
    private final Component name;
    private final Container contents;
    private final OwnerData owner;

    public BasicEjectionData(@Nonnull OwnerData owner, @Nonnull List<ItemStack> contents, @Nonnull Component name) {
        this(owner, (Container)InventoryUtil.buildInventory(contents), name);
    }

    public BasicEjectionData(@Nonnull OwnerData owner, @Nonnull Container contents, @Nonnull Component name) {
        this.name = name;
        this.contents = new NonEmptyContainer(contents);
        this.owner = new OwnerData(this);
        this.owner.copyFrom(owner);
    }

    @Override
    @Nonnull
    public OwnerData getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public Component getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public EjectionDataType getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public Container getContents() {
        return this.contents;
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag tag) {
        tag.m_128365_("Owner", (Tag)this.owner.save());
        tag.m_128359_("Name", Component.Serializer.m_130703_((Component)this.name));
        tag.m_128405_("Size", this.contents.m_6643_());
        InventoryUtil.saveAllItems("Contents", tag, this.contents);
    }

    private static class Type
    extends EjectionDataType {
        private Type() {
        }

        @Override
        @Nonnull
        public EjectionData load(@Nonnull CompoundTag tag) {
            OwnerData owner = new OwnerData(IClientTracker.forClient());
            owner.load(tag);
            MutableComponent name = Component.Serializer.m_130701_((String)tag.m_128461_("Name"));
            SimpleContainer contents = InventoryUtil.loadAllItems("Contents", tag, tag.m_128451_("Size"));
            return new BasicEjectionData(owner, (Container)contents, (Component)name);
        }
    }
}

